/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers;

import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class EnrichMoreSubject
extends UpdateMatcher<Result, Pair<String, String>> {
    public EnrichMoreSubject() {
        super(true);
    }

    @Override
    protected List<UpdateInfo<Pair<String, String>>> findUpdates(Result source, Result target) {
        Set existingSubjects = target.getSubject().stream().map(pid -> pid.getQualifier().getClassid() + "::" + pid.getValue()).collect(Collectors.toSet());
        return source.getPid().stream().filter(pid -> !existingSubjects.contains(pid.getQualifier().getClassid() + "::" + pid.getValue())).map(ConversionUtils::oafSubjectToPair).map(i -> this.generateUpdateInfo((Pair<String, String>)i, source, target)).collect(Collectors.toList());
    }

    @Override
    public UpdateInfo<Pair<String, String>> generateUpdateInfo(Pair<String, String> highlightValue, Result source, Result target) {
        return new UpdateInfo<Pair<String, String>>(Topic.fromPath("ENRICH/MORE/SUBJECT/" + (String)highlightValue.getLeft()), highlightValue, source, target, (p, pair) -> p.getSubjects().add(pair.getRight()), pair -> (String)pair.getLeft() + "::" + (String)pair.getRight());
    }
}

