/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers;

import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class UpdateMatcher<K, T> {
    private final boolean multipleUpdate;

    public UpdateMatcher(boolean multipleUpdate) {
        this.multipleUpdate = multipleUpdate;
    }

    public Collection<UpdateInfo<T>> searchUpdatesForRecord(K res, Collection<K> others) {
        HashMap<String, UpdateInfo<T>> infoMap = new HashMap<String, UpdateInfo<T>>();
        for (K source : others) {
            if (source == res) continue;
            for (UpdateInfo<T> info : this.findUpdates(source, res)) {
                String s = DigestUtils.md5Hex((String)info.getHighlightValueAsString());
                if (!infoMap.containsKey(s) || ((UpdateInfo)infoMap.get(s)).getTrust() < info.getTrust()) continue;
                infoMap.put(s, info);
            }
        }
        Collection<UpdateInfo<T>> values = infoMap.values();
        if (values.isEmpty() || this.multipleUpdate) {
            return values;
        }
        UpdateInfo<T> v = values.stream().sorted((o1, o2) -> Float.compare(o1.getTrust(), o2.getTrust())).findFirst().get();
        return Arrays.asList(v);
    }

    protected abstract List<UpdateInfo<T>> findUpdates(K var1, K var2);

    protected abstract UpdateInfo<T> generateUpdateInfo(T var1, K var2, K var3);

    protected static boolean isMissing(List<Field<String>> list) {
        return list == null || list.isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)list.get(0).getValue()));
    }

    protected boolean isMissing(Field<String> field) {
        return field == null || StringUtils.isBlank((CharSequence)((CharSequence)field.getValue()));
    }
}

