/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.broker.objects.Publication;
import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class UpdateInfo<T> {
    private final Topic topic;
    private final T highlightValue;
    private final Result source;
    private final Result target;
    private final BiConsumer<Publication, T> compileHighlight;
    private final Function<T, String> highlightToString;
    private final float trust;

    public UpdateInfo(Topic topic, T highlightValue, Result source, Result target, BiConsumer<Publication, T> compileHighlight, Function<T, String> highlightToString) {
        this.topic = topic;
        this.highlightValue = highlightValue;
        this.source = source;
        this.target = target;
        this.compileHighlight = compileHighlight;
        this.highlightToString = highlightToString;
        this.trust = this.calculateTrust(source, target);
    }

    public T getHighlightValue() {
        return this.highlightValue;
    }

    public Result getSource() {
        return this.source;
    }

    public Result getTarget() {
        return this.target;
    }

    private float calculateTrust(Result source, Result target) {
        return 0.9f;
    }

    protected Topic getTopic() {
        return this.topic;
    }

    public String getTopicPath() {
        return this.topic.getPath();
    }

    public float getTrust() {
        return this.trust;
    }

    public void compileHighlight(OpenAireEventPayload payload) {
        this.compileHighlight.accept(payload.getHighlight(), (Publication)this.getHighlightValue());
    }

    public String getHighlightValueAsString() {
        return this.highlightToString.apply(this.getHighlightValue());
    }
}

