/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers.simple;

import eu.dnetlib.broker.objects.Instance;
import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class EnrichMissingOpenAccess
extends UpdateMatcher<Result, Instance> {
    public EnrichMissingOpenAccess() {
        super(true);
    }

    @Override
    protected List<UpdateInfo<Instance>> findUpdates(Result source, Result target) {
        long count = target.getInstance().stream().map(i -> i.getAccessright().getClassid()).filter(right -> right.equals("OPEN")).count();
        if (count > 0L) {
            return Arrays.asList(new UpdateInfo[0]);
        }
        return source.getInstance().stream().filter(i -> i.getAccessright().getClassid().equals("OPEN")).map(ConversionUtils::oafInstanceToBrokerInstances).flatMap(s -> s).map(i -> this.generateUpdateInfo((Instance)i, source, target)).collect(Collectors.toList());
    }

    @Override
    public UpdateInfo<Instance> generateUpdateInfo(Instance highlightValue, Result source, Result target) {
        return new UpdateInfo<Instance>(Topic.ENRICH_MISSING_OA_VERSION, highlightValue, source, target, (p, i) -> p.getInstances().add(i), Instance::getUrl);
    }
}

