/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers.simple;

import eu.dnetlib.broker.objects.Pid;
import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EnrichMorePid
extends UpdateMatcher<Result, Pid> {
    public EnrichMorePid() {
        super(true);
    }

    @Override
    protected List<UpdateInfo<Pid>> findUpdates(Result source, Result target) {
        Set existingPids = target.getPid().stream().map(pid -> pid.getQualifier().getClassid() + "::" + pid.getValue()).collect(Collectors.toSet());
        return source.getPid().stream().filter(pid -> !existingPids.contains(pid.getQualifier().getClassid() + "::" + pid.getValue())).map(ConversionUtils::oafPidToBrokerPid).map(i -> this.generateUpdateInfo((Pid)i, source, target)).collect(Collectors.toList());
    }

    @Override
    public UpdateInfo<Pid> generateUpdateInfo(Pid highlightValue, Result source, Result target) {
        return new UpdateInfo<Pid>(Topic.ENRICH_MORE_PID, highlightValue, source, target, (p, pid) -> p.getPids().add(pid), pid -> pid.getType() + "::" + pid.getValue());
    }
}

