/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.broker.objects.OaBrokerProject;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.broker.oa.util.aggregators.withRels.RelatedProject;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareRelatedProjectsJob {
    private static final Logger log = LoggerFactory.getLogger(PrepareRelatedProjectsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)PrepareRelatedProjectsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/common_params.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String graphPath = parser.get("graphPath");
        log.info("graphPath: {}", (Object)graphPath);
        String workingDir = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingDir);
        String relsPath = workingDir + "/relatedProjects";
        log.info("relsPath: {}", (Object)relsPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            ClusterUtils.removeDir(spark, relsPath);
            LongAccumulator total = spark.sparkContext().longAccumulator("total_rels");
            Dataset projects = ClusterUtils.readPath(spark, graphPath + "/project", Project.class).filter((FilterFunction & Serializable)p -> !ClusterUtils.isDedupRoot(p.getId())).map(ConversionUtils::oafProjectToBrokerProject, Encoders.bean(OaBrokerProject.class));
            Dataset rels = ClusterUtils.loadRelations(graphPath, spark).filter((FilterFunction & Serializable)r -> r.getDataInfo().getDeletedbyinference()).filter((FilterFunction & Serializable)r -> r.getRelType().equals("resultProject")).filter((FilterFunction & Serializable)r -> !r.getRelClass().equals("isMergedIn")).filter((FilterFunction & Serializable)r -> !ClusterUtils.isDedupRoot(r.getSource())).filter((FilterFunction & Serializable)r -> !ClusterUtils.isDedupRoot(r.getTarget()));
            Dataset dataset = rels.joinWith(projects, projects.col("openaireId").equalTo((Object)rels.col("target")), "inner").map((MapFunction & Serializable)t -> new RelatedProject(((Relation)t._1).getSource(), (OaBrokerProject)t._2), Encoders.bean(RelatedProject.class));
            ClusterUtils.save(dataset, relsPath, RelatedProject.class, total);
        });
    }
}

