/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareSimpleEntititiesJob {
    private static final Logger log = LoggerFactory.getLogger(PrepareSimpleEntititiesJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)PrepareSimpleEntititiesJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/common_params.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String graphPath = parser.get("graphPath");
        log.info("graphPath: {}", (Object)graphPath);
        String workingDir = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingDir);
        String simpleEntitiesPath = workingDir + "/simpleEntities";
        log.info("simpleEntitiesPath: {}", (Object)simpleEntitiesPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            ClusterUtils.removeDir(spark, simpleEntitiesPath);
            LongAccumulator total = spark.sparkContext().longAccumulator("total_entities");
            org.apache.spark.sql.Dataset dataset = PrepareSimpleEntititiesJob.prepareSimpleEntities(spark, graphPath, Publication.class).union(PrepareSimpleEntititiesJob.prepareSimpleEntities(spark, graphPath, Dataset.class)).union(PrepareSimpleEntititiesJob.prepareSimpleEntities(spark, graphPath, Software.class)).union(PrepareSimpleEntititiesJob.prepareSimpleEntities(spark, graphPath, OtherResearchProduct.class));
            ClusterUtils.save(dataset, simpleEntitiesPath, OaBrokerMainEntity.class, total);
        });
    }

    private static <SRC extends Result> org.apache.spark.sql.Dataset<OaBrokerMainEntity> prepareSimpleEntities(SparkSession spark, String graphPath, Class<SRC> sourceClass) {
        Encoder encoder = Encoders.bean(OaBrokerMainEntity.class);
        return ClusterUtils.readPath(spark, graphPath + "/" + sourceClass.getSimpleName().toLowerCase(), sourceClass).filter((FilterFunction & Serializable)r -> !ClusterUtils.isDedupRoot(r.getId())).filter((FilterFunction & Serializable)r -> r.getDataInfo().getDeletedbyinference()).map(ConversionUtils::oafResultToBrokerResult, encoder);
    }
}

