/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers.simple;

import eu.dnetlib.broker.objects.OaBrokerInstance;
import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class EnrichMissingOpenAccess
extends UpdateMatcher<OaBrokerInstance> {
    public EnrichMissingOpenAccess() {
        super(20, i -> Topic.ENRICH_MISSING_OA_VERSION, (p, i) -> p.getInstances().add(i), OaBrokerInstance::getUrl);
    }

    @Override
    protected List<OaBrokerInstance> findDifferences(OaBrokerMainEntity source, OaBrokerMainEntity target) {
        if (target.getInstances().size() >= 50) {
            return new ArrayList<OaBrokerInstance>();
        }
        long count = target.getInstances().stream().map(OaBrokerInstance::getLicense).filter(right -> right.equals("OPEN")).count();
        if (count > 0L) {
            return Arrays.asList(new OaBrokerInstance[0]);
        }
        return source.getInstances().stream().filter(i -> i.getLicense().equals("OPEN")).collect(Collectors.toList());
    }
}

