/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import com.fasterxml.jackson.core.JsonProcessingException;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.EventGroup;
import eu.dnetlib.dhp.broker.oa.util.aggregators.subset.EventSubsetAggregator;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateEventSubsetJob {
    private static final Logger log = LoggerFactory.getLogger(GenerateEventSubsetJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GenerateEventSubsetJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/generate_event_subset.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        String eventsPath = parser.get("outputDir") + "/events";
        log.info("eventsPath: {}", (Object)eventsPath);
        String eventsSubsetPath = parser.get("outputDir") + "/events_subset";
        log.info("eventsSubsetPath: {}", (Object)eventsSubsetPath);
        int maxEventsForTopic = NumberUtils.toInt((String)parser.get("maxEventsForTopic"));
        log.info("maxEventsForTopic: {}", (Object)maxEventsForTopic);
        SparkSession spark = SparkSession.builder().config(conf).getOrCreate();
        TypedColumn aggr = new EventSubsetAggregator(maxEventsForTopic).toColumn();
        long now = new Date().getTime();
        LongAccumulator total = spark.sparkContext().longAccumulator("total_events_subset");
        log.info("*** Prepare subset for indexing");
        Dataset subset = ClusterUtils.readPath(spark, eventsPath, Event.class).groupByKey((MapFunction & Serializable)e -> e.getTopic() + '@' + e.getMap().getTargetDatasourceId(), Encoders.STRING()).agg(aggr).map((MapFunction & Serializable)t -> (EventGroup)t._2, Encoders.bean(EventGroup.class)).flatMap((FlatMapFunction & Serializable)g -> g.getData().iterator(), Encoders.bean(Event.class)).map((MapFunction & Serializable)e -> GenerateEventSubsetJob.prepareEventForIndexing(e, now), Encoders.bean(Event.class));
        ClusterUtils.save(subset, eventsSubsetPath, Event.class, total);
        log.info("*** ALL DONE");
    }

    private static Event prepareEventForIndexing(Event e, long creationDate) throws JsonProcessingException {
        e.setCreationDate(creationDate);
        e.setExpiryDate(Long.MAX_VALUE);
        return e;
    }
}

