/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.samples;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.broker.model.ConditionParams;
import eu.dnetlib.dhp.broker.model.MapCondition;
import eu.dnetlib.dhp.broker.oa.util.SubscriptionUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled
public class SimpleVariableJobTest {
    private static final Logger log = LoggerFactory.getLogger(SimpleVariableJobTest.class);
    private static Path workingDir;
    private static SparkSession spark;
    private static final List<String> inputList;
    private static final Map<String, Map<String, List<ConditionParams>>> staticMap;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(SimpleVariableJobTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(SimpleVariableJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        spark = SparkSession.builder().appName(SimpleVariableJobTest.class.getSimpleName()).config(conf).getOrCreate();
        for (int i = 0; i < 1000000; ++i) {
            inputList.add("record " + i);
        }
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    public void testSimpleVariableJob() throws Exception {
        Map<String, Map<String, List<ConditionParams>>> map = SimpleVariableJobTest.fillMap();
        long n = spark.createDataset(inputList, Encoders.STRING()).filter((FilterFunction & Serializable)s -> SimpleVariableJobTest.filter((Map)map.get(s))).map(String::toLowerCase, Encoders.STRING()).count();
        System.out.println(n);
    }

    @Test
    public void testSimpleVariableJob_static() throws Exception {
        staticMap.putAll(SimpleVariableJobTest.fillMap());
        long n = spark.createDataset(inputList, Encoders.STRING()).filter((FilterFunction & Serializable)s -> SimpleVariableJobTest.filter(staticMap.get(s))).map(String::toLowerCase, Encoders.STRING()).count();
        System.out.println(n);
    }

    private static Map<String, Map<String, List<ConditionParams>>> fillMap() throws JsonParseException, JsonMappingException, IOException {
        String s = "[{\"field\":\"targetDatasourceName\",\"fieldType\":\"STRING\",\"operator\":\"EXACT\",\"listParams\":[{\"value\":\"reposiTUm\"}]},{\"field\":\"trust\",\"fieldType\":\"FLOAT\",\"operator\":\"RANGE\",\"listParams\":[{\"value\":\"0\",\"otherValue\":\"1\"}]}]";
        ObjectMapper mapper = new ObjectMapper();
        List list = (List)mapper.readValue("[{\"field\":\"targetDatasourceName\",\"fieldType\":\"STRING\",\"operator\":\"EXACT\",\"listParams\":[{\"value\":\"reposiTUm\"}]},{\"field\":\"trust\",\"fieldType\":\"FLOAT\",\"operator\":\"RANGE\",\"listParams\":[{\"value\":\"0\",\"otherValue\":\"1\"}]}]", (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, MapCondition.class));
        Map<String, List> conditions = list.stream().filter(mc -> !mc.getListParams().isEmpty()).collect(Collectors.toMap(MapCondition::getField, MapCondition::getListParams));
        HashMap<String, Map<String, List<ConditionParams>>> map = new HashMap<String, Map<String, List<ConditionParams>>>();
        inputList.forEach(i -> map.put((String)i, (Map<String, List<ConditionParams>>)conditions));
        return map;
    }

    private static boolean filter(Map<String, List<ConditionParams>> conditions) {
        return !conditions.containsKey("targetDatasourceName") || SubscriptionUtils.verifyExact((String)"reposiTUm", (String)conditions.get("targetDatasourceName").get(0).getValue());
    }

    static {
        inputList = new ArrayList<String>();
        staticMap = new HashMap<String, Map<String, List<ConditionParams>>>();
    }
}

