/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.EventFinder;
import eu.dnetlib.dhp.broker.oa.util.EventGroup;
import eu.dnetlib.dhp.broker.oa.util.aggregators.simple.ResultGroup;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateEventsJob {
    private static final Logger log = LoggerFactory.getLogger(GenerateEventsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GenerateEventsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/generate_events.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String workingDir = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingDir);
        String eventsPath = parser.get("outputDir") + "/events";
        log.info("eventsPath: {}", (Object)eventsPath);
        Set<String> dsIdWhitelist = ClusterUtils.parseParamAsList(parser, "datasourceIdWhitelist");
        log.info("datasourceIdWhitelist: {}", (Object)StringUtils.join(dsIdWhitelist, (String)","));
        Set<String> dsTypeWhitelist = ClusterUtils.parseParamAsList(parser, "datasourceTypeWhitelist");
        log.info("datasourceTypeWhitelist: {}", (Object)StringUtils.join(dsTypeWhitelist, (String)","));
        Set<String> dsIdBlacklist = ClusterUtils.parseParamAsList(parser, "datasourceIdBlacklist");
        log.info("datasourceIdBlacklist: {}", (Object)StringUtils.join(dsIdBlacklist, (String)","));
        Set<String> topicWhitelist = ClusterUtils.parseParamAsList(parser, "topicWhitelist");
        log.info("topicWhitelist: {}", (Object)StringUtils.join(topicWhitelist, (String)","));
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            ClusterUtils.removeDir(spark, eventsPath);
            Map<String, LongAccumulator> accumulators = GenerateEventsJob.prepareAccumulators(spark.sparkContext());
            LongAccumulator total = spark.sparkContext().longAccumulator("total_events");
            Dataset<ResultGroup> groups = ClusterUtils.readPath(spark, workingDir + "/duplicates", ResultGroup.class);
            Dataset dataset = groups.map((MapFunction & Serializable)g -> EventFinder.generateEvents(g, dsIdWhitelist, dsIdBlacklist, dsTypeWhitelist, topicWhitelist, accumulators), Encoders.bean(EventGroup.class)).flatMap((FlatMapFunction & Serializable)g -> g.getData().iterator(), Encoders.bean(Event.class));
            ClusterUtils.save(dataset, eventsPath, Event.class, total);
        });
    }

    public static Map<String, LongAccumulator> prepareAccumulators(SparkContext sc) {
        return EventFinder.getMatchers().stream().map(UpdateMatcher::accumulatorName).distinct().collect(Collectors.toMap(s -> s, s -> sc.longAccumulator(s)));
    }
}

