/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers.simple;

import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.broker.objects.OaBrokerTypedValue;
import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EnrichMissingSubject
extends UpdateMatcher<OaBrokerTypedValue> {
    public EnrichMissingSubject() {
        super(20, s -> {
            switch (s.getType().toLowerCase()) {
                case "acm": {
                    return Topic.ENRICH_MISSING_SUBJECT_ACM;
                }
                case "arxiv": {
                    return Topic.ENRICH_MISSING_SUBJECT_ARXIV;
                }
                case "ddc": {
                    return Topic.ENRICH_MISSING_SUBJECT_DDC;
                }
                case "jel": {
                    return Topic.ENRICH_MISSING_SUBJECT_JEL;
                }
                case "mesh": {
                    return Topic.ENRICH_MISSING_SUBJECT_MESHEUROPMC;
                }
                case "rvk": {
                    return Topic.ENRICH_MISSING_SUBJECT_RVK;
                }
            }
            return null;
        }, (p, s) -> p.getSubjects().add(s), EnrichMissingSubject::subjectAsString);
    }

    @Override
    protected List<OaBrokerTypedValue> findDifferences(OaBrokerMainEntity source, OaBrokerMainEntity target) {
        if (target.getSubjects().size() >= 50) {
            return new ArrayList<OaBrokerTypedValue>();
        }
        Set existingSubject = target.getSubjects().stream().map(EnrichMissingSubject::subjectAsString).collect(Collectors.toSet());
        return source.getSubjects().stream().filter(s -> !existingSubject.contains(EnrichMissingSubject.subjectAsString(s))).collect(Collectors.toList());
    }

    private static String subjectAsString(OaBrokerTypedValue s) {
        return s.getType() + "::" + s.getValue();
    }
}

