/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import eu.dnetlib.broker.objects.OaBrokerAuthor;
import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConversionUtilsTest {
    @BeforeEach
    public void setUp() throws Exception {
    }

    @Test
    public void testAllResultPids() {
        Qualifier qf = new Qualifier();
        qf.setClassid("test");
        qf.setClassname("test");
        qf.setSchemeid("test");
        qf.setSchemename("test");
        StructuredProperty sp1 = new StructuredProperty();
        sp1.setValue("1");
        sp1.setQualifier(qf);
        StructuredProperty sp2 = new StructuredProperty();
        sp2.setValue("2");
        sp2.setQualifier(qf);
        StructuredProperty sp3 = new StructuredProperty();
        sp3.setValue("3");
        sp3.setQualifier(qf);
        StructuredProperty sp4a = new StructuredProperty();
        sp4a.setValue("4");
        sp4a.setQualifier(qf);
        StructuredProperty sp4b = new StructuredProperty();
        sp4b.setValue("4");
        sp4b.setQualifier(qf);
        StructuredProperty sp5 = new StructuredProperty();
        sp5.setValue("5");
        sp5.setQualifier(qf);
        StructuredProperty sp6a = new StructuredProperty();
        sp6a.setValue("6");
        sp6a.setQualifier(qf);
        StructuredProperty sp6b = new StructuredProperty();
        sp6b.setValue("6");
        sp6b.setQualifier(qf);
        Result oaf = new Result();
        oaf.setPid(new ArrayList());
        oaf.getPid().add(sp1);
        oaf.getPid().add(sp2);
        oaf.getPid().add(sp4a);
        Instance instance1 = new Instance();
        instance1.setPid(new ArrayList());
        instance1.setAlternateIdentifier(new ArrayList());
        instance1.getPid().add(sp3);
        instance1.getPid().add(sp4b);
        instance1.getAlternateIdentifier().add(sp5);
        instance1.getAlternateIdentifier().add(sp6a);
        Instance instance2 = new Instance();
        instance2.setPid(new ArrayList());
        instance2.setAlternateIdentifier(new ArrayList());
        instance2.getPid().add(sp6b);
        oaf.setInstance(new ArrayList());
        oaf.getInstance().add(instance1);
        oaf.getInstance().add(instance2);
        List list = ConversionUtils.allResultPids((Result)oaf);
        Assertions.assertEquals((int)6, (int)list.size());
    }

    public void testOafResultToBrokerResult() {
        Author a1 = this.createAuthor("Michele Artini", "0000-0002-4406-428X");
        Author a2 = this.createAuthor("Claudio Atzori", "http://orcid.org/0000-0001-9613-6639");
        Author a3 = this.createAuthor("Alessia Bardi", null);
        Result r = new Result();
        r.setAuthor(Arrays.asList(a1, a2, a3));
        OaBrokerMainEntity br = ConversionUtils.oafResultToBrokerResult((Result)r);
        Assertions.assertEquals((int)3, (int)br.getCreators().size());
        Assertions.assertEquals((Object)"0000-0002-4406-428X", (Object)((OaBrokerAuthor)br.getCreators().get(0)).getOrcid());
        Assertions.assertEquals((Object)"0000-0001-9613-6639", (Object)((OaBrokerAuthor)br.getCreators().get(1)).getOrcid());
        Assertions.assertNull((Object)((OaBrokerAuthor)br.getCreators().get(2)).getOrcid());
    }

    private Author createAuthor(String name, String orcid) {
        Author a = new Author();
        a.setFullname("Michele Artini");
        if (orcid != null) {
            Qualifier q = new Qualifier();
            q.setClassid("orcid");
            q.setClassname("orcid");
            q.setSchemeid("dnet:pids");
            q.setSchemename("dnet:pids");
            StructuredProperty pid = new StructuredProperty();
            pid.setQualifier(q);
            pid.setValue(orcid);
            a.setPid(Arrays.asList(pid));
        }
        return a;
    }
}

