/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers;

import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.broker.objects.OaBrokerRelatedDatasource;
import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.util.LongAccumulator;

public abstract class UpdateMatcher<T> {
    private final int maxNumber;
    private final Function<T, Topic> topicFunction;
    private final BiConsumer<OaBrokerMainEntity, T> compileHighlightFunction;
    private final Function<T, String> highlightToStringFunction;

    protected UpdateMatcher(int maxNumber, Function<T, Topic> topicFunction, BiConsumer<OaBrokerMainEntity, T> compileHighlightFunction, Function<T, String> highlightToStringFunction) {
        this.maxNumber = maxNumber;
        this.topicFunction = topicFunction;
        this.compileHighlightFunction = compileHighlightFunction;
        this.highlightToStringFunction = highlightToStringFunction;
    }

    public Collection<UpdateInfo<T>> searchUpdatesForRecord(OaBrokerMainEntity target, OaBrokerRelatedDatasource targetDs, Collection<OaBrokerMainEntity> others, Map<String, LongAccumulator> accumulators) {
        HashMap<String, UpdateInfo<T>> infoMap = new HashMap<String, UpdateInfo<T>>();
        for (OaBrokerMainEntity source : others) {
            if (source == target) continue;
            for (T hl : this.findDifferences(source, target)) {
                UpdateInfo<T> info;
                String s;
                Topic topic = this.getTopicFunction().apply(hl);
                if (topic == null || infoMap.containsKey(s = DigestUtils.md5Hex((String)(info = new UpdateInfo<T>(topic, hl, source, target, targetDs, this.getCompileHighlightFunction(), this.getHighlightToStringFunction())).getHighlightValueAsString())) && !(((UpdateInfo)infoMap.get(s)).getTrust() < info.getTrust())) continue;
                infoMap.put(s, info);
            }
        }
        List<UpdateInfo<T>> values = infoMap.values().stream().sorted((o1, o2) -> Float.compare(o2.getTrust(), o1.getTrust())).collect(Collectors.toList());
        if (values.isEmpty()) {
            return new ArrayList<UpdateInfo<T>>();
        }
        if (values.size() > this.maxNumber) {
            this.incrementAccumulator(accumulators, this.maxNumber);
            return values.subList(0, this.maxNumber);
        }
        this.incrementAccumulator(accumulators, values.size());
        return values;
    }

    protected abstract List<T> findDifferences(OaBrokerMainEntity var1, OaBrokerMainEntity var2);

    protected static boolean isMissing(List<String> list) {
        return list == null || list.isEmpty() || StringUtils.isBlank((CharSequence)list.get(0));
    }

    protected boolean isMissing(String s) {
        return StringUtils.isBlank((CharSequence)s);
    }

    public int getMaxNumber() {
        return this.maxNumber;
    }

    public Function<T, Topic> getTopicFunction() {
        return this.topicFunction;
    }

    public BiConsumer<OaBrokerMainEntity, T> getCompileHighlightFunction() {
        return this.compileHighlightFunction;
    }

    public Function<T, String> getHighlightToStringFunction() {
        return this.highlightToStringFunction;
    }

    public String accumulatorName() {
        return "event_matcher_" + this.getClass().getSimpleName().toLowerCase();
    }

    public void incrementAccumulator(Map<String, LongAccumulator> accumulators, long n) {
        if (accumulators != null && accumulators.containsKey(this.accumulatorName())) {
            accumulators.get(this.accumulatorName()).add(n);
        }
    }
}

