/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.oa.CountAggregator;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class CheckDuplictedIdsJob {
    private static final Logger log = LoggerFactory.getLogger(CheckDuplictedIdsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)CheckDuplictedIdsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/check_duplicates.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        String eventsPath = parser.get("outputDir") + "/events";
        log.info("eventsPath: {}", (Object)eventsPath);
        String countPath = parser.get("outputDir") + "/counts";
        log.info("countPath: {}", (Object)countPath);
        SparkSession spark = SparkSession.builder().config(conf).getOrCreate();
        LongAccumulator total = spark.sparkContext().longAccumulator("invaild_event_id");
        Encoder encoder = Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.LONG());
        ClusterUtils.readPath(spark, eventsPath, Event.class).map((MapFunction & Serializable)e -> new Tuple2((Object)e.getEventId(), (Object)1L), encoder).groupByKey((MapFunction & Serializable)t -> (String)t._1, Encoders.STRING()).agg(new CountAggregator().toColumn()).map((MapFunction & Serializable)t -> (Tuple2)t._2, encoder).filter((FilterFunction & Serializable)t -> (Long)t._2 > 1L).map((MapFunction & Serializable)o -> ClusterUtils.incrementAccumulator(o, total), encoder).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(countPath);
    }
}

