/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.broker.objects.OaBrokerRelatedDataset;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.broker.oa.util.aggregators.withRels.RelatedDataset;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareRelatedDatasetsJob {
    private static final Logger log = LoggerFactory.getLogger(PrepareRelatedDatasetsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)PrepareRelatedDatasetsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/common_params.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String graphPath = parser.get("graphPath");
        log.info("graphPath: {}", (Object)graphPath);
        String workingDir = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingDir);
        String relsPath = workingDir + "/relatedDatasets";
        log.info("relsPath: {}", (Object)relsPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            ClusterUtils.removeDir(spark, relsPath);
            LongAccumulator total = spark.sparkContext().longAccumulator("total_rels");
            org.apache.spark.sql.Dataset datasets = ClusterUtils.readPath(spark, graphPath + "/dataset", Dataset.class).filter((FilterFunction & Serializable)d -> !ClusterUtils.isDedupRoot(d.getId())).map(ConversionUtils::oafDatasetToBrokerDataset, Encoders.bean(OaBrokerRelatedDataset.class));
            org.apache.spark.sql.Dataset rels = ClusterUtils.loadRelations(graphPath, spark).filter((FilterFunction & Serializable)r -> r.getDataInfo().getDeletedbyinference()).filter((FilterFunction & Serializable)r -> r.getRelType().equals("resultResult")).filter((FilterFunction & Serializable)r -> ClusterUtils.isValidResultResultClass(r.getRelClass())).filter((FilterFunction & Serializable)r -> !ClusterUtils.isDedupRoot(r.getSource())).filter((FilterFunction & Serializable)r -> !ClusterUtils.isDedupRoot(r.getTarget()));
            org.apache.spark.sql.Dataset dataset = rels.joinWith(datasets, datasets.col("openaireId").equalTo((Object)rels.col("target")), "inner").map((MapFunction & Serializable)t -> {
                RelatedDataset rel = new RelatedDataset(((Relation)t._1).getSource(), (OaBrokerRelatedDataset)t._2);
                rel.getRelDataset().setRelType(((Relation)t._1).getRelClass());
                return rel;
            }, Encoders.bean(RelatedDataset.class));
            ClusterUtils.save(dataset, relsPath, RelatedDataset.class, total);
        });
    }
}

