/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.dhp.broker.model.ConditionParams;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.model.MappedFields;
import eu.dnetlib.dhp.broker.model.Subscription;
import eu.dnetlib.dhp.broker.oa.GenerateNotificationsJob;
import eu.dnetlib.dhp.broker.oa.util.NotificationGroup;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class GenerateNotificationsJobTest {
    private List<Subscription> subscriptions;
    private Map<String, Map<String, List<ConditionParams>>> conditionsMap;
    private static final int N_TIMES = 1000000;

    GenerateNotificationsJobTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        Subscription s = new Subscription();
        s.setTopic("ENRICH/MISSING/PID");
        s.setConditions("[{\"field\":\"targetDatasourceName\",\"fieldType\":\"STRING\",\"operator\":\"EXACT\",\"listParams\":[{\"value\":\"reposiTUm\"}]},{\"field\":\"trust\",\"fieldType\":\"FLOAT\",\"operator\":\"RANGE\",\"listParams\":[{\"value\":\"0\",\"otherValue\":\"1\"}]}]");
        this.subscriptions = Arrays.asList(s);
        this.conditionsMap = GenerateNotificationsJob.prepareConditionsMap(this.subscriptions);
    }

    @Test
    void testGenerateNotifications_invalid_topic() {
        Event event = new Event();
        event.setTopic("ENRICH/MISSING/PROJECT");
        NotificationGroup res = GenerateNotificationsJob.generateNotifications((Event)event, this.subscriptions, this.conditionsMap, (long)0L);
        Assertions.assertEquals((int)0, (int)res.getData().size());
    }

    @Test
    void testGenerateNotifications_topic_match() {
        Event event = new Event();
        event.setTopic("ENRICH/MISSING/PID");
        event.setMap(new MappedFields());
        event.getMap().setTargetDatasourceName("reposiTUm");
        event.getMap().setTrust(0.8f);
        NotificationGroup res = GenerateNotificationsJob.generateNotifications((Event)event, this.subscriptions, this.conditionsMap, (long)0L);
        Assertions.assertEquals((int)1, (int)res.getData().size());
    }

    @Test
    void testGenerateNotifications_topic_no_match() {
        Event event = new Event();
        event.setTopic("ENRICH/MISSING/PID");
        event.setMap(new MappedFields());
        event.getMap().setTargetDatasourceName("Puma");
        event.getMap().setTrust(0.8f);
        NotificationGroup res = GenerateNotificationsJob.generateNotifications((Event)event, this.subscriptions, this.conditionsMap, (long)0L);
        Assertions.assertEquals((int)0, (int)res.getData().size());
    }

    @Test
    void testGenerateNotifications_invalid_topic_repeated() {
        Event event = new Event();
        event.setTopic("ENRICH/MISSING/PROJECT");
        GenerateNotificationsJob.generateNotifications((Event)event, this.subscriptions, this.conditionsMap, (long)0L);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            GenerateNotificationsJob.generateNotifications((Event)event, this.subscriptions, this.conditionsMap, (long)0L);
        }
        long end = System.currentTimeMillis();
        System.out.println(String.format("no topic - repeated %s times - execution time: %s ms ", 1000000, end - start));
    }

    @Test
    void testGenerateNotifications_topic_match_repeated() {
        Event event = new Event();
        event.setTopic("ENRICH/MISSING/PID");
        event.setMap(new MappedFields());
        event.getMap().setTargetDatasourceName("reposiTUm");
        event.getMap().setTrust(0.8f);
        GenerateNotificationsJob.generateNotifications((Event)event, this.subscriptions, this.conditionsMap, (long)0L);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            GenerateNotificationsJob.generateNotifications((Event)event, this.subscriptions, this.conditionsMap, (long)0L);
        }
        long end = System.currentTimeMillis();
        System.out.println(String.format("topic match - repeated %s times - execution time: %s ms ", 1000000, end - start));
    }

    @Test
    void testGenerateNotifications_topic_no_match_repeated() {
        Event event = new Event();
        event.setTopic("ENRICH/MISSING/PID");
        event.setMap(new MappedFields());
        event.getMap().setTargetDatasourceName("Puma");
        event.getMap().setTrust(0.8f);
        GenerateNotificationsJob.generateNotifications((Event)event, this.subscriptions, this.conditionsMap, (long)0L);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            GenerateNotificationsJob.generateNotifications((Event)event, this.subscriptions, this.conditionsMap, (long)0L);
        }
        long end = System.currentTimeMillis();
        System.out.println(String.format("topic no match - repeated %s times - execution time: %s ms ", 1000000, end - start));
    }
}

