/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import eu.dnetlib.dhp.broker.oa.util.SubscriptionUtils;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SubscriptionUtilsTest {
    @Test
    void testVerifyListSimilar() {
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyListSimilar(Arrays.asList("Michele Artini", "Claudio Atzori"), (String)"artini"));
        Assertions.assertFalse((boolean)SubscriptionUtils.verifyListSimilar(Arrays.asList("Michele Artini", "Claudio Atzori"), (String)"bardi"));
    }

    @Test
    void testVerifyListExact() {
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyListExact(Arrays.asList("Java", "Perl"), (String)"perl"));
        Assertions.assertFalse((boolean)SubscriptionUtils.verifyListExact(Arrays.asList("Java", "Perl"), (String)"C"));
    }

    @Test
    void testVerifySimilar() {
        Assertions.assertTrue((boolean)SubscriptionUtils.verifySimilar((String)"Java Programming", (String)"java"));
        Assertions.assertFalse((boolean)SubscriptionUtils.verifySimilar((String)"Java Programming", (String)"soap"));
    }

    @Test
    void testVerifyFloatRange() {
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyFloatRange((float)0.5f, (String)"0.4", (String)"0.6"));
        Assertions.assertFalse((boolean)SubscriptionUtils.verifyFloatRange((float)0.8f, (String)"0.4", (String)"0.6"));
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyFloatRange((float)0.5f, (String)"", (String)""));
    }

    @Test
    void testVerifyDateRange() {
        long date = 1282738478000L;
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, (String)"2010-01-01", (String)"2011-01-01"));
        Assertions.assertFalse((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, (String)"2020-01-01", (String)"2021-01-01"));
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, (String)"2010-01-01", (String)"NULL"));
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, (String)"2010-01-01", null));
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, (String)"NULL", (String)"2011-01-01"));
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, null, (String)"2011-01-01"));
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, (String)"NULL", (String)"NULL"));
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, null, null));
        Assertions.assertFalse((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, (String)"2020-01-01", null));
        Assertions.assertFalse((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, (String)"2020-01-01", (String)"NULL"));
        Assertions.assertFalse((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, null, (String)"2005-01-01"));
        Assertions.assertFalse((boolean)SubscriptionUtils.verifyDateRange((long)1282738478000L, (String)"NULL", (String)"2005-01-01"));
    }

    @Test
    void testVerifyExact() {
        Assertions.assertTrue((boolean)SubscriptionUtils.verifyExact((String)"Java Programming", (String)"java programming"));
        Assertions.assertFalse((boolean)SubscriptionUtils.verifyExact((String)"Java Programming", (String)"soap programming"));
    }
}

