/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.OaNotification;
import eu.dnetlib.dhp.broker.oa.util.BrokerIndexClient;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.index.es.ConvertJSONWithId;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexNotificationsJob {
    private static final Logger log = LoggerFactory.getLogger(IndexNotificationsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)IndexNotificationsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/index_notifications.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        String notificationsPath = parser.get("outputDir") + "/notifications";
        log.info("notificationsPath: {}", (Object)notificationsPath);
        String index = parser.get("index");
        log.info("index: {}", (Object)index);
        String indexHost = parser.get("esHost");
        log.info("indexHost: {}", (Object)indexHost);
        String brokerApiBaseUrl = parser.get("brokerApiBaseUrl");
        log.info("brokerApiBaseUrl: {}", (Object)brokerApiBaseUrl);
        SparkSession spark = SparkSession.builder().config(conf).getOrCreate();
        Long date = ((OaNotification)ClusterUtils.readPath(spark, notificationsPath, OaNotification.class).first()).getDate();
        try (BrokerIndexClient feeder = new BrokerIndexClient(indexHost);){
            FileSystem fileSystem = FileSystem.get((Configuration)new Configuration());
            List<Path> files = ClusterUtils.listFiles(notificationsPath, fileSystem, ".gz");
            log.info("*** Start indexing");
            feeder.parallelBulkIndex(files, 4, fileSystem, (Function)new ConvertJSONWithId("\"notificationId\":\"((\\d|\\w|-)*)\"", index));
            log.info("*** Deleting old notifications");
            feeder.deleteUsingDateBefore(index, "date", date - 1000L, true);
            feeder.refreshIndex(index);
        }
        if (StringUtils.isBlank((CharSequence)brokerApiBaseUrl) || !StringUtils.startsWith((CharSequence)brokerApiBaseUrl, (CharSequence)"http")) {
            log.warn("brokerApiBaseUrl is not set, skipping sendNotifications");
        } else {
            log.info("*** sendNotifications (emails, ...)");
            IndexNotificationsJob.sendNotifications(brokerApiBaseUrl, date - 1000L);
        }
        log.info("*** ALL done.");
    }

    private static String sendNotifications(String brokerApiBaseUrl, long l) throws IOException {
        String url = brokerApiBaseUrl + "/api/openaireBroker/notifications/send/" + l;
        HttpGet req = new HttpGet(url);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            String string;
            block12: {
                CloseableHttpResponse response = client.execute((HttpUriRequest)req);
                try {
                    string = IOUtils.toString((InputStream)response.getEntity().getContent());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }
}

