/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util.aggregators.subset;

import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.oa.util.EventGroup;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.expressions.Aggregator;

public class EventSubsetAggregator
extends Aggregator<Event, EventGroup, EventGroup> {
    private static final long serialVersionUID = -678071078823059805L;
    private final int maxEventsForTopic;

    public EventSubsetAggregator(int maxEventsForTopic) {
        this.maxEventsForTopic = maxEventsForTopic;
    }

    public EventGroup zero() {
        return new EventGroup();
    }

    public EventGroup reduce(EventGroup g, Event e) {
        if (g.getData().size() < this.maxEventsForTopic) {
            g.getData().add(e);
        }
        return g;
    }

    public EventGroup merge(EventGroup g0, EventGroup g1) {
        int missing = this.maxEventsForTopic - g0.getData().size();
        if (missing > 0) {
            if (g1.getData().size() < missing) {
                g0.getData().addAll(g1.getData());
            } else {
                g0.getData().addAll(g1.getData().subList(0, missing));
            }
        }
        return g0;
    }

    public EventGroup finish(EventGroup g) {
        return g;
    }

    public Encoder<EventGroup> outputEncoder() {
        return Encoders.bean(EventGroup.class);
    }

    public Encoder<EventGroup> bufferEncoder() {
        return Encoders.bean(EventGroup.class);
    }
}

