/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers.simple;

import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.broker.objects.OaBrokerTypedValue;
import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EnrichMorePid
extends UpdateMatcher<OaBrokerTypedValue> {
    public EnrichMorePid() {
        super(20, pid -> Topic.ENRICH_MORE_PID, (p, pid) -> p.getPids().add(pid), EnrichMorePid::pidAsString);
    }

    @Override
    protected List<OaBrokerTypedValue> findDifferences(OaBrokerMainEntity source, OaBrokerMainEntity target) {
        if (target.getPids().size() >= 50) {
            return new ArrayList<OaBrokerTypedValue>();
        }
        Set existingPids = target.getPids().stream().map(EnrichMorePid::pidAsString).collect(Collectors.toSet());
        return source.getPids().stream().filter(pid -> !existingPids.contains(EnrichMorePid.pidAsString(pid))).collect(Collectors.toList());
    }

    private static String pidAsString(OaBrokerTypedValue pid) {
        return pid.getType() + "::" + pid.getValue();
    }
}

