/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.model;

import eu.dnetlib.broker.objects.OaBrokerAuthor;
import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.broker.objects.OaBrokerRelatedDatasource;
import eu.dnetlib.broker.objects.OaBrokerTypedValue;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.model.OaMappedFields;
import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import java.text.ParseException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class EventFactory {
    private static final String PRODUCER_ID = "OpenAIRE";
    private static final String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd"};

    private EventFactory() {
    }

    public static Event newBrokerEvent(UpdateInfo<?> updateInfo) {
        Event res = new Event();
        OaMappedFields map = EventFactory.createMapFromResult(updateInfo);
        String eventId = EventFactory.calculateEventId(updateInfo.getTopicPath(), updateInfo.getTargetDs().getOpenaireId(), updateInfo.getTarget().getOpenaireId(), updateInfo.getHighlightValueAsString());
        res.setEventId(eventId);
        res.setProducerId(PRODUCER_ID);
        res.setPayload(updateInfo.asBrokerPayload().toJSON());
        res.setMap(map);
        res.setTopic(updateInfo.getTopicPath());
        res.setCreationDate(0L);
        res.setExpiryDate(Long.MAX_VALUE);
        res.setInstantMessage(false);
        return res;
    }

    private static OaMappedFields createMapFromResult(UpdateInfo<?> updateInfo) {
        long date;
        OaMappedFields map = new OaMappedFields();
        OaBrokerMainEntity source = updateInfo.getSource();
        OaBrokerMainEntity target = updateInfo.getTarget();
        OaBrokerRelatedDatasource targetDs = updateInfo.getTargetDs();
        map.setTargetDatasourceId(targetDs.getOpenaireId());
        map.setTargetDatasourceName(targetDs.getName());
        map.setTargetDatasourceType(targetDs.getType());
        map.setTargetResultId(target.getOpenaireId());
        List titles = target.getTitles();
        if (!titles.isEmpty()) {
            map.setTargetResultTitle((String)titles.get(0));
        }
        if ((date = EventFactory.parseDateTolong(target.getPublicationdate())) > 0L) {
            map.setTargetDateofacceptance(date);
        }
        map.setTargetSubjects(target.getSubjects().stream().map(OaBrokerTypedValue::getValue).collect(Collectors.toList()));
        map.setTargetAuthors(target.getCreators().stream().map(OaBrokerAuthor::getFullname).collect(Collectors.toList()));
        map.setTrust(updateInfo.getTrust());
        map.setProvenanceResultId(source.getOpenaireId());
        source.getDatasources().stream().filter(ds -> "collectedFrom".equals(ds.getRelType())).findFirst().ifPresent(ds -> {
            map.setProvenanceDatasourceId(ds.getOpenaireId());
            map.setProvenanceDatasourceName(ds.getName());
            map.setProvenanceDatasourceType(ds.getType());
        });
        return map;
    }

    private static String calculateEventId(String topic, String dsId, String publicationId, String value) {
        return "event-" + DigestUtils.md5Hex((String)topic).substring(0, 4) + "-" + DigestUtils.md5Hex((String)dsId).substring(0, 4) + "-" + DigestUtils.md5Hex((String)publicationId).substring(0, 7) + "-" + DigestUtils.md5Hex((String)value).substring(0, 5);
    }

    private static long parseDateTolong(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return -1L;
        }
        try {
            return DateUtils.parseDate((String)date, (String[])DATE_PATTERNS).getTime();
        }
        catch (ParseException e) {
            return -1L;
        }
    }
}

