/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import java.text.ParseException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SubscriptionUtils {
    private static final long ONE_DAY = 86400000L;

    private SubscriptionUtils() {
    }

    public static boolean verifyListSimilar(List<String> list, String value) {
        return list.stream().anyMatch(s -> SubscriptionUtils.verifySimilar(s, value));
    }

    public static boolean verifyListExact(List<String> list, String value) {
        return list.stream().anyMatch(s -> SubscriptionUtils.verifyExact(s, value));
    }

    public static boolean verifySimilar(String s1, String s2) {
        for (String part : s2.split("\\W+")) {
            if (StringUtils.containsIgnoreCase((CharSequence)s1, (CharSequence)part)) continue;
            return false;
        }
        return true;
    }

    public static boolean verifyFloatRange(float trust, String min, String max) {
        return trust >= NumberUtils.toFloat((String)min, (float)0.0f) && trust <= NumberUtils.toFloat((String)max, (float)1.0f);
    }

    public static boolean verifyDateRange(long date, String min, String max) {
        long from = 0L;
        long to = Long.MAX_VALUE;
        try {
            from = min != null ? DateUtils.parseDate((String)min, (String[])new String[]{"yyyy-MM-dd"}).getTime() : 0L;
        }
        catch (ParseException e) {
            from = 0L;
        }
        try {
            to = max != null ? DateUtils.parseDate((String)max, (String[])new String[]{"yyyy-MM-dd"}).getTime() + 86400000L : Long.MAX_VALUE;
        }
        catch (ParseException e) {
            to = Long.MAX_VALUE;
        }
        return date >= from && date < to;
    }

    public static boolean verifyExact(String s1, String s2) {
        return StringUtils.equalsIgnoreCase((CharSequence)s1, (CharSequence)s2);
    }
}

