/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa_alerts;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.oa.util.BrokerIndexClient;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.index.es.ConvertJSONWithId;
import eu.dnetlib.dhp.schema.mdstore.Provenance;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexAlertNotificationsJob {
    private static final Logger log = LoggerFactory.getLogger(IndexAlertNotificationsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)IndexAlertNotificationsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa_alert/index_alert_notifications.json")));
        parser.parseArgument(args);
        String notificationsPath = parser.get("path");
        log.info("notificationsPath: {}", (Object)notificationsPath);
        String index = parser.get("index");
        log.info("index: {}", (Object)index);
        String indexHost = parser.get("esHost");
        log.info("indexHost: {}", (Object)indexHost);
        String dsId = ((Provenance)DHPUtils.MAPPER.readValue(parser.get("provenance"), Provenance.class)).getDatasourceId();
        log.info("dsId: {}", (Object)dsId);
        String brokerApiBaseUrl = parser.get("brokerApiBaseUrl");
        log.info("brokerApiBaseUrl: {}", (Object)brokerApiBaseUrl);
        try (BrokerIndexClient feeder = new BrokerIndexClient(indexHost);){
            log.info("*** Clean old notifications");
            feeder.deleteUsingExactField(index, "map.datasourceId", dsId, true);
            FileSystem fileSystem = FileSystem.get((Configuration)new Configuration());
            List<Path> files = ClusterUtils.listFiles(notificationsPath, fileSystem, ".gz");
            log.info("*** Start indexing");
            feeder.parallelBulkIndex(files, 4, fileSystem, (Function)new ConvertJSONWithId("\"notificationId\":\"((\\d|\\w|-)*)\"", index));
            feeder.refreshIndex(index);
        }
        log.info("*** sendNotifications (emails, ...)");
        IndexAlertNotificationsJob.sendAlertNotifications(brokerApiBaseUrl, dsId);
        log.info("*** ALL done.");
    }

    private static String sendAlertNotifications(String brokerApiBaseUrl, String dsId) throws IOException {
        String url = brokerApiBaseUrl + "/api/openaire-alerts/notifications/sendMailForNotifications?dsId=" + dsId;
        HttpGet req = new HttpGet(url);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            String string;
            block12: {
                CloseableHttpResponse response = client.execute((HttpUriRequest)req);
                try {
                    string = IOUtils.toString((InputStream)response.getEntity().getContent());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }
}

