/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import eu.dnetlib.broker.objects.OaBrokerAuthor;
import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.broker.objects.OaBrokerTypedValue;
import eu.dnetlib.dhp.broker.oa.util.TrustUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TrustUtilsTest {
    private static final double THRESHOLD = 0.95;

    @Test
    void rescaleTest_1() {
        this.verifyValue(-0.3, 0.25f);
    }

    @Test
    void rescaleTest_2() {
        this.verifyValue(0.0, 0.25f);
    }

    @Test
    void rescaleTest_3() {
        this.verifyValue(0.5, 0.25f);
    }

    @Test
    void rescaleTest_4() {
        this.verifyValue(0.95, 0.25f);
    }

    @Test
    void rescaleTest_5() {
        this.verifyValue(0.96, 0.25f);
    }

    @Test
    void rescaleTest_6() {
        this.verifyValue(0.97, 0.3f);
    }

    @Test
    void rescaleTest_7() {
        this.verifyValue(0.98, 0.45f);
    }

    @Test
    void rescaleTest_8() {
        this.verifyValue(0.99, 0.6f);
    }

    @Test
    void rescaleTest_9() {
        this.verifyValue(1.0, 1.0f);
    }

    @Test
    void rescaleTest_10() {
        this.verifyValue(1.01, 1.0f);
    }

    @Test
    void rescaleTest_11() {
        this.verifyValue(2.0, 1.0f);
    }

    @Test
    void test() {
        OaBrokerMainEntity r1 = new OaBrokerMainEntity();
        r1.getTitles().add("D-NET Service Package: Data Import");
        r1.getPids().add(new OaBrokerTypedValue("doi", "123"));
        r1.getCreators().add(new OaBrokerAuthor("Michele Artini", null));
        r1.getCreators().add(new OaBrokerAuthor("Claudio Atzori", null));
        OaBrokerMainEntity r2 = new OaBrokerMainEntity();
        r2.getTitles().add("D-NET Service Package: Data Import");
        r2.getCreators().add(new OaBrokerAuthor("Michele Artini", null));
        System.out.println("TRUST: " + TrustUtils.calculateTrust((OaBrokerMainEntity)r1, (OaBrokerMainEntity)r2));
    }

    private void verifyValue(double originalScore, float expectedTrust) {
        float trust = TrustUtils.rescale((double)originalScore, (double)0.95);
        System.out.println(trust);
        Assertions.assertTrue(((double)Math.abs(trust - expectedTrust) < 0.01 ? 1 : 0) != 0);
    }
}

