/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.aggregators.withRels.RelatedDataset;
import eu.dnetlib.dhp.broker.oa.util.aggregators.withRels.RelatedDatasetAggregator;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinStep3Job {
    private static final Logger log = LoggerFactory.getLogger(JoinStep3Job.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)JoinStep3Job.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/common_params.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String workingDir = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingDir);
        String joinedEntitiesPath = workingDir + "/joinedEntities_step3";
        log.info("joinedEntitiesPath: {}", (Object)joinedEntitiesPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            ClusterUtils.removeDir(spark, joinedEntitiesPath);
            LongAccumulator total = spark.sparkContext().longAccumulator("total_entities");
            Dataset<OaBrokerMainEntity> sources = ClusterUtils.readPath(spark, workingDir + "/joinedEntities_step2", OaBrokerMainEntity.class);
            Dataset<RelatedDataset> typedRels = ClusterUtils.readPath(spark, workingDir + "/relatedDatasets", RelatedDataset.class);
            TypedColumn aggr = new RelatedDatasetAggregator().toColumn();
            Dataset dataset = sources.joinWith(typedRels, sources.col("openaireId").equalTo((Object)typedRels.col("source")), "left_outer").groupByKey((MapFunction & Serializable)t -> ((OaBrokerMainEntity)t._1).getOpenaireId(), Encoders.STRING()).agg(aggr).map((MapFunction & Serializable)t -> (OaBrokerMainEntity)t._2, Encoders.bean(OaBrokerMainEntity.class));
            ClusterUtils.save(dataset, joinedEntitiesPath, OaBrokerMainEntity.class, total);
        });
    }
}

