/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.tasks.GetTasksResponse;
import co.elastic.clients.util.ObjectBuilder;
import eu.dnetlib.dhp.index.es.ESFeeder;
import java.io.IOException;

public class BrokerIndexClient
extends ESFeeder {
    public BrokerIndexClient(String url) {
        super(url);
    }

    public void deleteUsingExactField(String index, String field, String value, boolean waitTermination) throws ElasticsearchException, IOException {
        DeleteByQueryRequest req = DeleteByQueryRequest.of(b -> b.index(index, new String[0]).waitForCompletion(Boolean.valueOf(false)).conflicts(Conflicts.Proceed).query(q -> q.term(t -> t.field(field).value(value))));
        DeleteByQueryResponse res = this.getEsClient().deleteByQuery(req);
        if (waitTermination) {
            this.waitForTaskCompletion(res.task());
        }
    }

    public void deleteUsingDateBefore(String index, String field, double date, boolean waitTermination) throws ElasticsearchException, IOException {
        DeleteByQueryRequest req = DeleteByQueryRequest.of(b -> b.index(index, new String[0]).waitForCompletion(Boolean.valueOf(false)).conflicts(Conflicts.Proceed).query(q -> q.range(r -> r.number(n -> (ObjectBuilder)n.field(field).lte((Object)date)))));
        this.getEsClient().deleteByQuery(req);
        DeleteByQueryResponse res = this.getEsClient().deleteByQuery(req);
        if (waitTermination) {
            this.waitForTaskCompletion(res.task());
        }
    }

    private void waitForTaskCompletion(String task) throws ElasticsearchException, IOException {
        GetTasksResponse taskStatus;
        while ((taskStatus = this.getEsClient().tasks().get(t -> t.taskId(task))) != null && !taskStatus.completed()) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

