/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.broker.objects.OaBrokerRelatedSoftware;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.broker.oa.util.aggregators.withRels.RelatedSoftware;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareRelatedSoftwaresJob {
    private static final Logger log = LoggerFactory.getLogger(PrepareRelatedSoftwaresJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)PrepareRelatedSoftwaresJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/common_params.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String graphPath = parser.get("graphPath");
        log.info("graphPath: {}", (Object)graphPath);
        String rawRelsPath = parser.get("rawRelsPath");
        log.info("rawRelsPath: {}", (Object)rawRelsPath);
        String workingDir = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingDir);
        String relsPath = workingDir + "/relatedSoftwares";
        log.info("relsPath: {}", (Object)relsPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            ClusterUtils.removeDir(spark, relsPath);
            LongAccumulator total = spark.sparkContext().longAccumulator("total_rels");
            Encoder obrsEncoder = Encoders.bean(OaBrokerRelatedSoftware.class);
            Dataset softwares = ClusterUtils.readPath(spark, graphPath + "/software", Software.class).filter((FilterFunction & Serializable)sw -> !ClusterUtils.isDedupRoot(sw.getId())).map(ConversionUtils::oafSoftwareToBrokerSoftware, obrsEncoder);
            Dataset<Relation> rels = ClusterUtils.loadRawRelations(rawRelsPath, "resultResult", spark);
            Encoder rsEncoder = Encoders.bean(RelatedSoftware.class);
            Dataset dataset = rels.joinWith(softwares, softwares.col("openaireId").equalTo((Object)rels.col("target")), "inner").map((MapFunction & Serializable)t -> new RelatedSoftware(((Relation)t._1).getSource(), (OaBrokerRelatedSoftware)t._2), rsEncoder);
            ClusterUtils.save(dataset, relsPath, RelatedSoftware.class, total);
        });
    }
}

