/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.maven.plugin.properties;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class WritePredefinedProjectProperties
extends AbstractMojo {
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String TAB = "\t";
    protected static final String PROPERTY_PREFIX_ENV = "env.";
    private static final String ENCODING_UTF8 = "utf8";
    private String[] includePropertyKeysFromFiles;
    protected MavenProject project;
    protected File outputFile;
    private boolean quiet;
    private String escapeChars;
    private boolean includeSystemProperties;
    private boolean includeEnvironmentVariables;
    private String exclude;
    private String include;

    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"})
    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.project.getProperties());
        if (this.includeEnvironmentVariables) {
            properties.putAll((Map<?, ?>)WritePredefinedProjectProperties.getEnvironmentVariables());
        }
        if (this.includeSystemProperties) {
            properties.putAll((Map<?, ?>)System.getProperties());
        }
        this.trim(properties, this.exclude, this.include);
        String comment = "# " + new Date() + LF;
        List<String> escapeTokens = this.getEscapeChars(this.escapeChars);
        this.getLog().info((CharSequence)("Creating " + this.outputFile));
        this.writeProperties(this.outputFile, comment, properties, escapeTokens);
    }

    protected static Properties getEnvironmentVariables() {
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            props.setProperty(PROPERTY_PREFIX_ENV + entry.getKey(), entry.getValue());
        }
        return props;
    }

    protected void trim(Properties properties, String omitCSV, String includeCSV) throws MojoExecutionException {
        List<String> omitKeys = WritePredefinedProjectProperties.getListFromCSV(omitCSV);
        for (String string : omitKeys) {
            properties.remove(string);
        }
        List<String> includeKeys = WritePredefinedProjectProperties.getListFromCSV(includeCSV);
        if (this.includePropertyKeysFromFiles != null && this.includePropertyKeysFromFiles.length > 0) {
            for (String currentIncludeLoc : this.includePropertyKeysFromFiles) {
                if (!this.validate(currentIncludeLoc)) continue;
                Properties p = this.getProperties(currentIncludeLoc);
                for (String key : p.stringPropertyNames()) {
                    includeKeys.add(key);
                }
            }
        }
        if (includeKeys != null && !includeKeys.isEmpty()) {
            Set<String> set = properties.stringPropertyNames();
            for (String key : set) {
                if (includeKeys.contains(key)) continue;
                properties.remove(key);
            }
        }
    }

    protected boolean exists(String location) {
        if (StringUtils.isBlank((String)location)) {
            return false;
        }
        File file = new File(location);
        if (file.exists()) {
            return true;
        }
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource(location);
        return resource.exists();
    }

    protected boolean validate(String location) throws MojoExecutionException {
        boolean exists = this.exists(location);
        if (exists) {
            return true;
        }
        if (this.quiet) {
            this.getLog().info((CharSequence)("Ignoring non-existent properties file '" + location + "'"));
            return false;
        }
        throw new MojoExecutionException("Non-existent properties file '" + location + "'");
    }

    protected InputStream getInputStream(String location) throws IOException {
        File file = new File(location);
        if (file.exists()) {
            return new FileInputStream(location);
        }
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource(location);
        return resource.getInputStream();
    }

    protected Properties getProperties(String location) throws MojoExecutionException {
        Properties properties;
        InputStream in = null;
        try {
            Properties properties2 = new Properties();
            in = this.getInputStream(location);
            if (location.toLowerCase().endsWith(".xml")) {
                properties2.loadFromXML(in);
            } else {
                properties2.load(in);
            }
            properties = properties2;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error reading properties file " + location, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return properties;
    }

    protected List<String> getEscapeChars(String escapeChars) {
        List<String> tokens = WritePredefinedProjectProperties.getListFromCSV(escapeChars);
        ArrayList<String> realTokens = new ArrayList<String>();
        for (String token : tokens) {
            String realToken = this.getRealToken(token);
            realTokens.add(realToken);
        }
        return realTokens;
    }

    protected String getRealToken(String token) {
        if (token.equalsIgnoreCase("CR")) {
            return CR;
        }
        if (token.equalsIgnoreCase("LF")) {
            return LF;
        }
        if (token.equalsIgnoreCase("TAB")) {
            return TAB;
        }
        return token;
    }

    protected String getContent(String comment, Properties properties, List<String> escapeTokens) {
        ArrayList<String> names = new ArrayList<String>(properties.stringPropertyNames());
        Collections.sort(names);
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isBlank((String)comment)) {
            sb.append(comment);
        }
        for (String name : names) {
            String value = properties.getProperty(name);
            String escapedValue = this.escape(value, escapeTokens);
            sb.append(name + "=" + escapedValue + LF);
        }
        return sb.toString();
    }

    protected void writeProperties(File file, String comment, Properties properties, List<String> escapeTokens) throws MojoExecutionException {
        try {
            String content = this.getContent(comment, properties, escapeTokens);
            FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating properties file", (Exception)e);
        }
    }

    protected String escape(String s, List<String> escapeChars) {
        String result = s;
        for (String escapeChar : escapeChars) {
            result = result.replace(escapeChar, this.getReplacementToken(escapeChar));
        }
        return result;
    }

    protected String getReplacementToken(String escapeChar) {
        if (escapeChar.equals(CR)) {
            return "\\r";
        }
        if (escapeChar.equals(LF)) {
            return "\\n";
        }
        if (escapeChar.equals(TAB)) {
            return "\\t";
        }
        return "\\" + escapeChar;
    }

    protected static final List<String> getListFromCSV(String csv) {
        String[] tokens;
        if (StringUtils.isBlank((String)csv)) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String token : tokens = StringUtils.split((String)csv, (String)",")) {
            list.add(token.trim());
        }
        return list;
    }

    public void setIncludeSystemProperties(boolean includeSystemProperties) {
        this.includeSystemProperties = includeSystemProperties;
    }

    public void setEscapeChars(String escapeChars) {
        this.escapeChars = escapeChars;
    }

    public void setIncludeEnvironmentVariables(boolean includeEnvironmentVariables) {
        this.includeEnvironmentVariables = includeEnvironmentVariables;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setIncludePropertyKeysFromFiles(String[] includePropertyKeysFromFiles) {
        if (includePropertyKeysFromFiles != null) {
            this.includePropertyKeysFromFiles = Arrays.copyOf(includePropertyKeysFromFiles, includePropertyKeysFromFiles.length);
        }
    }
}

