/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.collection;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DecompressTarGz {
    public static void doExtract(FileSystem fs, String outputPath, String tarGzPath) throws IOException {
        FSDataInputStream inputFileStream = fs.open(new Path(tarGzPath));
        try (TarArchiveInputStream tais = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)inputFileStream));){
            TarArchiveEntry entry = null;
            while ((entry = tais.getNextTarEntry()) != null) {
                if (entry.isDirectory()) continue;
                FSDataOutputStream out = fs.create(new Path(outputPath.concat(entry.getName()).concat(".gz")));
                Throwable throwable = null;
                try {
                    GZIPOutputStream gzipOs = new GZIPOutputStream(new BufferedOutputStream((OutputStream)out));
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)tais, (OutputStream)gzipOs);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (gzipOs == null) continue;
                        if (throwable2 != null) {
                            try {
                                gzipOs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        gzipOs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
    }
}

