/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph.scholix;

import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Subject;
import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixCollectedFrom;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixIdentifier;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixRelationship;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixResource;
import eu.dnetlib.dhp.schema.sx.summary.CollectedFromType;
import eu.dnetlib.dhp.schema.sx.summary.SchemeValue;
import eu.dnetlib.dhp.schema.sx.summary.ScholixSummary;
import eu.dnetlib.dhp.schema.sx.summary.Typology;
import eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.expressions.Aggregator;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class ScholixUtils$
implements Serializable {
    public static final ScholixUtils$ MODULE$;
    private final String DNET_IDENTIFIER_SCHEMA;
    private final String DATE_RELATION_KEY;
    private final Map<String, ScholixUtils.RelationVocabulary> relations;
    private final Aggregator<Tuple3<String, String, Object>, ScholixUtils.RelatedEntities, ScholixUtils.RelatedEntities> statsAggregator;
    private final Aggregator<Tuple2<String, Scholix>, Scholix, Scholix> scholixAggregator;

    static {
        new ScholixUtils$();
    }

    public String DNET_IDENTIFIER_SCHEMA() {
        return this.DNET_IDENTIFIER_SCHEMA;
    }

    public String DATE_RELATION_KEY() {
        return this.DATE_RELATION_KEY;
    }

    public Map<String, ScholixUtils.RelationVocabulary> relations() {
        return this.relations;
    }

    public String extractRelationDate(Relation relation) {
        Option date;
        return relation.getProperties() != null && relation.getProperties().isEmpty() ? ((date = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(relation.getProperties()).asScala()).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KeyValue p) {
                return ScholixUtils$.MODULE$.DATE_RELATION_KEY().equalsIgnoreCase(p.getKey());
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(KeyValue p) {
                return p.getValue();
            }
        })).isDefined() ? (String)date.get() : null) : null;
    }

    public String extractRelationDate(ScholixSummary summary) {
        return summary.getDate() == null || summary.getDate().isEmpty() ? null : (String)summary.getDate().get(0);
    }

    public ScholixRelationship inverseRelationShip(ScholixRelationship rel) {
        return new ScholixRelationship(rel.getInverse(), rel.getSchema(), rel.getName());
    }

    public ScholixResource generateScholixResourceFromResult(Result r) {
        return this.generateScholixResourceFromSummary(this.resultToSummary(r));
    }

    public Aggregator<Tuple3<String, String, Object>, ScholixUtils.RelatedEntities, ScholixUtils.RelatedEntities> statsAggregator() {
        return this.statsAggregator;
    }

    public Aggregator<Tuple2<String, Scholix>, Scholix, Scholix> scholixAggregator() {
        return this.scholixAggregator;
    }

    /*
     * WARNING - void declaration
     */
    public Scholix createInverseScholixRelation(Scholix scholix) {
        void var2_2;
        Scholix s = new Scholix();
        s.setPublicationDate(scholix.getPublicationDate());
        s.setPublisher(scholix.getPublisher());
        s.setLinkprovider(scholix.getLinkprovider());
        s.setRelationship(this.inverseRelationShip(scholix.getRelationship()));
        s.setSource(scholix.getTarget());
        s.setTarget(scholix.getSource());
        s.setIdentifier(DHPUtils.md5(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "::", "::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.getSource().getIdentifier(), s.getRelationship().getName(), s.getTarget().getIdentifier()}))));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public List<ScholixEntityId> extractCollectedFrom(ScholixResource summary) {
        Nil$ nil$;
        if (summary.getCollectedFrom() == null || summary.getCollectedFrom().isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            void var2_2;
            List l = (List)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(summary.getCollectedFrom()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ScholixEntityId apply(ScholixCollectedFrom d) {
                    return new ScholixEntityId(d.getProvider().getName(), d.getProvider().getIdentifiers());
                }
            }, scala.collection.package$.MODULE$.breakOut(List$.MODULE$.canBuildFrom()));
            nil$ = var2_2;
        }
        return nil$;
    }

    /*
     * WARNING - void declaration
     */
    public List<ScholixEntityId> extractCollectedFrom(ScholixSummary summary) {
        Nil$ nil$;
        if (summary.getDatasources() == null || summary.getDatasources().isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            void var2_2;
            List l = (List)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(summary.getDatasources()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ScholixEntityId apply(CollectedFromType d) {
                    return new ScholixEntityId(d.getDatasourceName(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScholixIdentifier[]{new ScholixIdentifier(d.getDatasourceId(), "DNET Identifier", null)}))).asJava());
                }
            }, scala.collection.package$.MODULE$.breakOut(List$.MODULE$.canBuildFrom()));
            nil$ = var2_2;
        }
        return nil$;
    }

    /*
     * WARNING - void declaration
     */
    public List<ScholixEntityId> extractCollectedFrom(Relation relation) {
        Nil$ nil$;
        if (relation.getCollectedfrom() == null || relation.getCollectedfrom().isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            void var2_2;
            List l = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(relation.getCollectedfrom()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ScholixEntityId apply(KeyValue c) {
                    return new ScholixEntityId(c.getValue(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScholixIdentifier[]{new ScholixIdentifier(c.getKey(), ScholixUtils$.MODULE$.DNET_IDENTIFIER_SCHEMA(), null)}))).asJava());
                }
            }, Buffer$.MODULE$.canBuildFrom())).toList();
            nil$ = var2_2;
        }
        return nil$;
    }

    /*
     * WARNING - void declaration
     */
    public Scholix generateCompleteScholix(Scholix scholix, ScholixSummary target) {
        void var3_3;
        Scholix s = new Scholix();
        s.setPublicationDate(scholix.getPublicationDate());
        s.setPublisher(scholix.getPublisher());
        s.setLinkprovider(scholix.getLinkprovider());
        s.setRelationship(scholix.getRelationship());
        s.setSource(scholix.getSource());
        s.setTarget(this.generateScholixResourceFromSummary(target));
        s.setIdentifier(DHPUtils.md5(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "::", "::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.getSource().getIdentifier(), s.getRelationship().getName(), s.getTarget().getIdentifier()}))));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Scholix generateCompleteScholix(Scholix scholix, ScholixResource target) {
        void var3_3;
        Scholix s = new Scholix();
        s.setPublicationDate(scholix.getPublicationDate());
        s.setPublisher(scholix.getPublisher());
        s.setLinkprovider(scholix.getLinkprovider());
        s.setRelationship(scholix.getRelationship());
        s.setSource(scholix.getSource());
        s.setTarget(target);
        s.setIdentifier(DHPUtils.md5(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "::", "::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.getSource().getIdentifier(), s.getRelationship().getName(), s.getTarget().getIdentifier()}))));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ScholixResource generateScholixResourceFromSummary(ScholixSummary summaryObject) {
        void var2_2;
        List l;
        List plist;
        List l2;
        ScholixResource r = new ScholixResource();
        r.setIdentifier(summaryObject.getLocalIdentifier());
        r.setDnetIdentifier(summaryObject.getId());
        r.setObjectType(summaryObject.getTypology().toString());
        r.setObjectSubType(summaryObject.getSubType());
        if (summaryObject.getTitle() != null && !summaryObject.getTitle().isEmpty()) {
            r.setTitle((String)summaryObject.getTitle().get(0));
        }
        if (summaryObject.getAuthor() != null && !summaryObject.getAuthor().isEmpty() && (l2 = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(summaryObject.getAuthor()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ScholixEntityId apply(String a) {
                return new ScholixEntityId(a, null);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList()).nonEmpty()) {
            r.setCreator((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)l2).asJava());
        }
        if (summaryObject.getDate() != null && !summaryObject.getDate().isEmpty()) {
            r.setPublicationDate((String)summaryObject.getDate().get(0));
        }
        if (summaryObject.getPublisher() != null && !summaryObject.getPublisher().isEmpty() && (plist = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(summaryObject.getPublisher()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ScholixEntityId apply(String p) {
                return new ScholixEntityId(p, null);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList()).nonEmpty()) {
            r.setPublisher((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)plist).asJava());
        }
        if (summaryObject.getDatasources() != null && !summaryObject.getDatasources().isEmpty() && (l = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(summaryObject.getDatasources()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ScholixCollectedFrom apply(CollectedFromType c) {
                return new ScholixCollectedFrom(new ScholixEntityId(c.getDatasourceName(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScholixIdentifier[]{new ScholixIdentifier(c.getDatasourceId(), ScholixUtils$.MODULE$.DNET_IDENTIFIER_SCHEMA(), null)}))).asJava()), "collected", "complete");
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList()).nonEmpty()) {
            r.setCollectedFrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)l).asJava());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Scholix scholixFromSource(Relation relation, ScholixResource source) {
        void var3_3;
        ScholixUtils.RelationVocabulary semanticRelation;
        if (relation == null || source == null) {
            return null;
        }
        Scholix s = new Scholix();
        List<ScholixEntityId> l = this.extractCollectedFrom(relation);
        if (l.isEmpty()) {
            l = this.extractCollectedFrom(source);
        }
        if (l.isEmpty()) {
            return null;
        }
        s.setLinkprovider((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(l).asJava());
        String d = this.extractRelationDate(relation);
        if (d == null) {
            d = source.getPublicationDate();
        }
        s.setPublicationDate(d);
        if (source.getPublisher() != null && !source.getPublisher().isEmpty()) {
            s.setPublisher(source.getPublisher());
        }
        if ((semanticRelation = (ScholixUtils.RelationVocabulary)this.relations().getOrElse((Object)relation.getRelClass().toLowerCase(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        })) == null) {
            return null;
        }
        s.setRelationship(new ScholixRelationship(semanticRelation.original(), "datacite", semanticRelation.inverse()));
        s.setSource(source);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Scholix scholixFromSource(Relation relation, ScholixSummary source) {
        void var3_3;
        ScholixUtils.RelationVocabulary semanticRelation;
        List l;
        if (relation == null || source == null) {
            return null;
        }
        Scholix s = new Scholix();
        List<ScholixEntityId> l2 = this.extractCollectedFrom(relation);
        if (l2.isEmpty()) {
            l2 = this.extractCollectedFrom(source);
        }
        if (l2.isEmpty()) {
            return null;
        }
        s.setLinkprovider((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(l2).asJava());
        String d = this.extractRelationDate(relation);
        if (d == null) {
            d = this.extractRelationDate(source);
        }
        s.setPublicationDate(d);
        if (source.getPublisher() != null && !source.getPublisher().isEmpty() && (l = (List)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(source.getPublisher()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ScholixEntityId apply(String p) {
                return new ScholixEntityId(p, null);
            }
        }, scala.collection.package$.MODULE$.breakOut(List$.MODULE$.canBuildFrom()))).nonEmpty()) {
            s.setPublisher((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)l).asJava());
        }
        if ((semanticRelation = (ScholixUtils.RelationVocabulary)this.relations().getOrElse((Object)relation.getRelClass().toLowerCase(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        })) == null) {
            return null;
        }
        s.setRelationship(new ScholixRelationship(semanticRelation.original(), "datacite", semanticRelation.inverse()));
        s.setSource(this.generateScholixResourceFromSummary(source));
        return var3_3;
    }

    public List<Tuple2<StructuredProperty, String>> findURLForPID(List<StructuredProperty> pidValue, List<String> urls) {
        return (List)pidValue.map((Function1)new Serializable(urls){
            public static final long serialVersionUID = 0L;
            private final List urls$1;

            public final Tuple2<StructuredProperty, String> apply(StructuredProperty p) {
                String pv = p.getValue();
                Option r = this.urls$1.find((Function1)new Serializable(this, pv){
                    public static final long serialVersionUID = 0L;
                    private final String pv$1;

                    public final boolean apply(String u) {
                        return u.toLowerCase().contains(this.pv$1.toLowerCase());
                    }
                    {
                        this.pv$1 = pv$1;
                    }
                });
                return new Tuple2((Object)p, r.orNull(Predef$.MODULE$.$conforms()));
            }
            {
                this.urls$1 = urls$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public List<ScholixIdentifier> extractTypedIdentifierFromInstance(Result r) {
        if (r.getInstance() == null || r.getInstance().isEmpty()) {
            return Nil$.MODULE$;
        }
        return ((TraversableOnce)((SeqLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getInstance()).asScala()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getUrl() != null && !i.getUrl().isEmpty();
            }
        })).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getPid() != null && i.getUrl() != null;
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<StructuredProperty, String>> apply(Instance i) {
                return ScholixUtils$.MODULE$.findURLForPID((List<StructuredProperty>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(i.getPid()).asScala()).toList(), (List<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(i.getUrl()).asScala()).toList());
            }
        }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ScholixIdentifier apply(Tuple2<StructuredProperty, String> i) {
                return new ScholixIdentifier(((StructuredProperty)i._1()).getValue(), ((StructuredProperty)i._1()).getQualifier().getClassid(), (String)i._2());
            }
        }, Buffer$.MODULE$.canBuildFrom())).distinct()).toList();
    }

    /*
     * WARNING - void declaration
     */
    public ScholixSummary resultToSummary(Result r) {
        void var2_2;
        List cf;
        List subjects;
        Option d;
        List dt;
        List authors;
        ScholixSummary s = new ScholixSummary();
        s.setId(r.getId());
        if (r.getPid() == null || r.getPid().isEmpty()) {
            return null;
        }
        List<ScholixIdentifier> persistentIdentifiers = this.extractTypedIdentifierFromInstance(r);
        if (persistentIdentifiers.isEmpty()) {
            return null;
        }
        s.setLocalIdentifier((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(persistentIdentifiers).asJava());
        if (r instanceof Publication) {
            s.setTypology(Typology.publication);
        } else {
            s.setTypology(Typology.dataset);
        }
        s.setSubType(((Instance)r.getInstance().get(0)).getInstancetype().getClassname());
        if (r.getTitle() != null && ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(r.getTitle()).asScala()).nonEmpty()) {
            List titles = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getTitle()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructuredProperty t) {
                    return t.getValue();
                }
            }, Buffer$.MODULE$.canBuildFrom())).toList();
            if (titles.nonEmpty()) {
                s.setTitle((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)titles).asJava());
            } else {
                return null;
            }
        }
        if (r.getAuthor() != null && !r.getAuthor().isEmpty() && (authors = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getAuthor()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Author a) {
                return a.getFullname();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList()).nonEmpty()) {
            s.setAuthor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)authors).asJava());
        }
        if (r.getInstance() != null && (dt = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getInstance()).asScala()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getDateofacceptance() != null;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Instance i) {
                return (String)i.getDateofacceptance().getValue();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList()).nonEmpty()) {
            s.setDate((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)dt.distinct()).asJava());
        }
        if (r.getDescription() != null && !r.getDescription().isEmpty() && (d = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getDescription()).asScala()).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Field<String> f) {
                return f != null && f.getValue() != null;
            }
        })).isDefined()) {
            s.setDescription((String)((Field)d.get()).getValue());
        }
        if (r.getSubject() != null && !r.getSubject().isEmpty() && (subjects = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getSubject()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SchemeValue apply(Subject s) {
                return new SchemeValue(s.getQualifier().getClassname(), s.getValue());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList()).nonEmpty()) {
            s.setSubject((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)subjects).asJava());
        }
        if (r.getPublisher() != null) {
            s.setPublisher((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)r.getPublisher().getValue()}))).asJava());
        }
        if (r.getCollectedfrom() != null && !r.getCollectedfrom().isEmpty() && (cf = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getCollectedfrom()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CollectedFromType apply(KeyValue c) {
                return new CollectedFromType(c.getValue(), c.getKey(), "complete");
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList()).nonEmpty()) {
            s.setDatasources((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)cf.distinct()).asJava());
        }
        s.setRelatedDatasets(0L);
        s.setRelatedPublications(0L);
        s.setRelatedUnknown(0L);
        return var2_2;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final DefaultFormats$ formats$lzycompute$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        ScholixUtils$ scholixUtils$ = this;
        synchronized (scholixUtils$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formats$lzy$1.elem = DefaultFormats$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$1.elem;
        }
    }

    private final DefaultFormats$ formats$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.formats$lzycompute$1(formats$lzy$1, bitmap$0$1) : (DefaultFormats$)formats$lzy$1.elem;
    }

    private final JsonAST.JValue json$lzycompute$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        ScholixUtils$ scholixUtils$ = this;
        synchronized (scholixUtils$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                json$lzy$1.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$1.elem;
        }
    }

    private final JsonAST.JValue json$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.json$lzycompute$1(input$1, json$lzy$1, bitmap$0$1) : (JsonAST.JValue)json$lzy$1.elem;
    }

    private ScholixUtils$() {
        MODULE$ = this;
        this.DNET_IDENTIFIER_SCHEMA = "DNET Identifier";
        this.DATE_RELATION_KEY = "RelationDate";
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String input = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/scholexplorer/relation/relations.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        this.relations = (Map)package$.MODULE$.jvalue2extractable(this.json$1(input, json$lzy, bitmap$0)).extract((Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(ScholixUtils.RelationVocabulary.class)})));
        this.statsAggregator = new Aggregator<Tuple3<String, String, Object>, ScholixUtils.RelatedEntities, ScholixUtils.RelatedEntities>(){

            public ScholixUtils.RelatedEntities zero() {
                return null;
            }

            public ScholixUtils.RelatedEntities reduce(ScholixUtils.RelatedEntities b, Tuple3<String, String, Object> a) {
                long relatedDataset = "dataset".equalsIgnoreCase((String)a._2()) ? BoxesRunTime.unboxToLong((Object)a._3()) : 0L;
                long relatedPublication = "publication".equalsIgnoreCase((String)a._2()) ? BoxesRunTime.unboxToLong((Object)a._3()) : 0L;
                return b == null ? new ScholixUtils.RelatedEntities((String)a._1(), relatedDataset, relatedPublication) : new ScholixUtils.RelatedEntities((String)a._1(), b.relatedDataset() + relatedDataset, b.relatedPublication() + relatedPublication);
            }

            public ScholixUtils.RelatedEntities merge(ScholixUtils.RelatedEntities b1, ScholixUtils.RelatedEntities b2) {
                return b1 == null || b2 == null ? (b1 == null ? b2 : b1) : new ScholixUtils.RelatedEntities(b1.id(), b1.relatedDataset() + b2.relatedDataset(), b1.relatedPublication() + b2.relatedPublication());
            }

            public ScholixUtils.RelatedEntities finish(ScholixUtils.RelatedEntities reduction) {
                return reduction;
            }

            public Encoder<ScholixUtils.RelatedEntities> bufferEncoder() {
                return Encoders$.MODULE$.bean(ScholixUtils.RelatedEntities.class);
            }

            public Encoder<ScholixUtils.RelatedEntities> outputEncoder() {
                return Encoders$.MODULE$.bean(ScholixUtils.RelatedEntities.class);
            }
        };
        this.scholixAggregator = new Aggregator<Tuple2<String, Scholix>, Scholix, Scholix>(){

            public Scholix zero() {
                return null;
            }

            private boolean scholix_complete(Scholix s) {
                return s == null || s.getIdentifier() == null ? false : (s.getSource() == null || s.getTarget() == null ? false : s.getLinkprovider() != null && !s.getLinkprovider().isEmpty());
            }

            public Scholix reduce(Scholix b, Tuple2<String, Scholix> a) {
                return this.scholix_complete(b) ? b : (Scholix)a._2();
            }

            public Scholix merge(Scholix b1, Scholix b2) {
                return this.scholix_complete(b1) ? b1 : b2;
            }

            public Scholix finish(Scholix reduction) {
                return reduction;
            }

            public Encoder<Scholix> bufferEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Scholix.class));
            }

            public Encoder<Scholix> outputEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Scholix.class));
            }
        };
    }
}

