/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf.utils;

import com.github.sisyphsu.dateparser.DateParserUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.merge.AuthorMerger;
import eu.dnetlib.dhp.schema.common.AccessRightComparator;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.EoscIfGuidelines;
import eu.dnetlib.dhp.schema.oaf.ExternalReference;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Measure;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.GraphCleaningFunctions;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.MergeEntitiesComparator;
import eu.dnetlib.dhp.schema.oaf.utils.PidCleaner;
import eu.dnetlib.dhp.schema.oaf.utils.RefereedComparator;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class MergeUtils {
    public static <T extends Oaf> T mergeById(Iterator<T> oafEntityIterator, VocabularyGroup vocs) {
        return MergeUtils.mergeGroup(oafEntityIterator, true, vocs);
    }

    public static <T extends Oaf> T mergeGroup(Iterator<T> oafEntityIterator) {
        return MergeUtils.mergeGroup(oafEntityIterator, false);
    }

    public static <T extends Oaf> T mergeGroup(Iterator<T> oafEntityIterator, boolean checkDelegateAuthority) {
        return MergeUtils.mergeGroup(oafEntityIterator, checkDelegateAuthority, null);
    }

    public static <T extends Oaf> T mergeGroup(Iterator<T> oafEntityIterator, boolean checkDelegateAuthority, VocabularyGroup vocs) {
        ArrayList<Oaf> sortedEntities = new ArrayList<Oaf>();
        oafEntityIterator.forEachRemaining(sortedEntities::add);
        sortedEntities.sort(MergeEntitiesComparator.INSTANCE.reversed());
        Iterator it = sortedEntities.iterator();
        Oaf merged = (Oaf)it.next();
        if (!it.hasNext() && merged instanceof Result && vocs != null) {
            return MergeUtils.enforceResultType(vocs, (Result)merged);
        }
        while (it.hasNext()) {
            merged = MergeUtils.checkedMerge(merged, (Oaf)it.next(), checkDelegateAuthority);
        }
        return (T)merged;
    }

    private static <T extends Oaf> T enforceResultType(VocabularyGroup vocs, Result mergedResult) {
        if (Optional.ofNullable(mergedResult.getInstance()).map(List::isEmpty).orElse(true).booleanValue()) {
            return (T)mergedResult;
        }
        Instance i = (Instance)mergedResult.getInstance().get(0);
        if (!vocs.vocabularyExists("dnet:result_typologies")) {
            return (T)mergedResult;
        }
        String expectedResultType = Optional.ofNullable(vocs.lookupTermBySynonym("dnet:result_typologies", i.getInstancetype().getClassid())).orElse(ModelConstants.ORP_DEFAULT_RESULTTYPE).getClassid();
        if (!expectedResultType.equals(mergedResult.getResulttype().getClassid())) {
            Result result = (Result)Optional.ofNullable((Class)ModelSupport.oafTypes.get(expectedResultType)).map(r -> {
                try {
                    return r.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException(e);
                }
            }).orElse(new OtherResearchProduct());
            result.setId(mergedResult.getId());
            return (T)MergeUtils.mergeResultFields(result, mergedResult);
        }
        return (T)mergedResult;
    }

    public static <T extends Oaf> T checkedMerge(T left, T right, boolean checkDelegateAuthority) {
        return (T)MergeUtils.merge(left, right, checkDelegateAuthority);
    }

    public static <T extends Result, E extends Result> Result mergeResult(T left, E right) {
        return (Result)MergeUtils.merge(left, right, false);
    }

    public static Oaf merge(Oaf left, Oaf right) {
        return MergeUtils.merge(left, right, false, false);
    }

    public static Oaf merge(Oaf left, Oaf right, boolean promoting) {
        return MergeUtils.merge(left, right, false, promoting);
    }

    static Oaf merge(Oaf left, Oaf right, boolean checkDelegatedAuthority, boolean promoting) {
        if (MergeUtils.sameClass(left, right, OafEntity.class)) {
            return MergeUtils.mergeEntities(left, right, checkDelegatedAuthority, promoting);
        }
        if (MergeUtils.sameClass(left, right, Relation.class)) {
            return MergeUtils.mergeRelation((Relation)left, (Relation)right);
        }
        throw new RuntimeException(String.format("MERGE_FROM_AND_GET incompatible types: %s, %s", left.getClass().getCanonicalName(), right.getClass().getCanonicalName()));
    }

    private static <T extends Oaf> boolean sameClass(Object left, Object right, Class<T> cls) {
        return cls.isAssignableFrom(left.getClass()) && cls.isAssignableFrom(right.getClass());
    }

    private static Oaf mergeEntities(Oaf left, Oaf right, boolean checkDelegatedAuthority, boolean promoting) {
        if (MergeUtils.sameClass(left, right, Result.class)) {
            if (checkDelegatedAuthority) {
                return MergeUtils.mergeResultsOfDifferentTypes((Result)left, (Result)right);
            }
            if (MergeUtils.sameClass(left, right, Publication.class)) {
                return MergeUtils.mergePublication((Publication)left, (Publication)right);
            }
            if (MergeUtils.sameClass(left, right, Dataset.class)) {
                return MergeUtils.mergeDataset((Dataset)left, (Dataset)right);
            }
            if (MergeUtils.sameClass(left, right, OtherResearchProduct.class)) {
                return MergeUtils.mergeORP((OtherResearchProduct)left, (OtherResearchProduct)right);
            }
            if (MergeUtils.sameClass(left, right, Software.class)) {
                return MergeUtils.mergeSoftware((Software)left, (Software)right);
            }
            if (Boolean.TRUE.equals(promoting)) {
                return MergeUtils.mergeResultFields((Result)left, (Result)right);
            }
            return left;
        }
        if (MergeUtils.sameClass(left, right, Datasource.class)) {
            int trust = MergeUtils.compareTrust(left, right);
            return MergeUtils.mergeOafEntityFields((Datasource)left, (Datasource)right, trust);
        }
        if (MergeUtils.sameClass(left, right, Organization.class)) {
            return MergeUtils.mergeOrganization((Organization)left, (Organization)right);
        }
        if (MergeUtils.sameClass(left, right, Project.class)) {
            return MergeUtils.mergeProject((Project)left, (Project)right);
        }
        throw new RuntimeException(String.format("MERGE_FROM_AND_GET incompatible types: %s, %s", left.getClass().getCanonicalName(), right.getClass().getCanonicalName()));
    }

    private static <T extends Result> T mergeResultsOfDifferentTypes(T left, T right) {
        boolean leftFromDelegatedAuthority = MergeUtils.isFromDelegatedAuthority(left);
        boolean rightFromDelegatedAuthority = MergeUtils.isFromDelegatedAuthority(right);
        if (leftFromDelegatedAuthority && !rightFromDelegatedAuthority) {
            return left;
        }
        if (!leftFromDelegatedAuthority && rightFromDelegatedAuthority) {
            return right;
        }
        if (MergeEntitiesComparator.INSTANCE.compare((Oaf)left, (Oaf)right) > 0) {
            return MergeUtils.mergeResultFields(left, right);
        }
        return MergeUtils.mergeResultFields(right, left);
    }

    private static DataInfo chooseDataInfo(DataInfo left, DataInfo right, int trust) {
        if (trust > 0) {
            return left;
        }
        if (trust == 0) {
            if (left == null || left.getInvisible() != null && left.getInvisible().equals(Boolean.TRUE)) {
                return right;
            }
            return left;
        }
        return right;
    }

    private static String chooseString(String left, String right, int trust) {
        if (trust > 0) {
            return left;
        }
        if (trust == 0) {
            return StringUtils.isNotBlank((CharSequence)left) ? left : right;
        }
        return right;
    }

    private static <T> T chooseReference(T left, T right, int trust) {
        if (trust > 0) {
            return left;
        }
        if (trust == 0) {
            return left != null ? left : right;
        }
        return right;
    }

    private static Long max(Long left, Long right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return Math.max(left, right);
    }

    private static Boolean booleanOR(Boolean a, Boolean b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a != false || b != false;
    }

    private static <T, K> List<T> mergeLists(List<T> left, List<T> right, int trust, Function<T, K> keyExtractor, BinaryOperator<T> merger) {
        if (left == null || left.isEmpty()) {
            return right != null ? right : new ArrayList();
        }
        if (right == null || right.isEmpty()) {
            return left;
        }
        List<T> h = trust >= 0 ? left : right;
        List<Object> l = trust >= 0 ? right : left;
        return new ArrayList(Stream.concat(h.stream(), l.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toMap(keyExtractor, v -> v, merger, LinkedHashMap::new)).values());
    }

    private static <T, K> List<T> unionDistinctLists(List<T> left, List<T> right, int trust) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        List<T> h = trust >= 0 ? left : right;
        List<T> l = trust >= 0 ? right : left;
        return Stream.concat(h.stream(), l.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private static List<String> unionDistinctListOfString(List<String> l, List<String> r) {
        if (l == null) {
            return r;
        }
        if (r == null) {
            return l;
        }
        return Stream.concat(l.stream(), r.stream()).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
    }

    private static List<KeyValue> mergeByKey(List<KeyValue> left, List<KeyValue> right, int trust) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (trust < 0) {
            List<KeyValue> s = left;
            left = right;
            right = s;
        }
        HashMap values = new HashMap();
        Optional.ofNullable(left).ifPresent(l -> l.forEach(kv -> values.put(kv.getKey(), kv)));
        Optional.ofNullable(right).ifPresent(r -> r.forEach(kv -> values.putIfAbsent(kv.getKey(), kv)));
        return new ArrayList<KeyValue>(values.values());
    }

    private static List<StructuredProperty> unionTitle(List<StructuredProperty> left, List<StructuredProperty> right, int trust) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        List<StructuredProperty> h = trust >= 0 ? left : right;
        List<StructuredProperty> l = trust >= 0 ? right : left;
        return Stream.concat(h.stream(), l.stream()).filter(Objects::isNull).distinct().collect(Collectors.toList());
    }

    private static <T extends Oaf> T mergeOafFields(T merged, T enrich, int trust) {
        merged.setCollectedfrom(MergeUtils.mergeByKey(merged.getCollectedfrom(), enrich.getCollectedfrom(), trust));
        merged.setDataInfo(MergeUtils.chooseDataInfo(merged.getDataInfo(), enrich.getDataInfo(), trust));
        merged.setLastupdatetimestamp(MergeUtils.max(merged.getLastupdatetimestamp(), enrich.getLastupdatetimestamp()));
        return merged;
    }

    private static <T extends OafEntity> T mergeOafEntityFields(T original, T enrich, int trust) {
        T merged = MergeUtils.mergeOafFields(original, enrich, trust);
        merged.setOriginalId(MergeUtils.unionDistinctListOfString(merged.getOriginalId(), enrich.getOriginalId()));
        merged.setPid(MergeUtils.mergeLists(merged.getPid(), enrich.getPid(), trust, MergeUtils::spKeyExtractor, (p1, p2) -> p1));
        merged.setDateofcollection(LocalDateTime.now().toString());
        merged.setDateoftransformation(MergeUtils.chooseString(merged.getDateoftransformation(), enrich.getDateoftransformation(), trust));
        merged.setExtraInfo(MergeUtils.unionDistinctLists(merged.getExtraInfo(), enrich.getExtraInfo(), trust));
        merged.setOaiprovenance(null);
        merged.setMeasures(MergeUtils.unionDistinctLists(merged.getMeasures(), enrich.getMeasures(), trust));
        return merged;
    }

    public static <T extends Relation> T mergeRelation(T original, T enrich) {
        int trust = MergeUtils.compareTrust(original, enrich);
        T merge = MergeUtils.mergeOafFields(original, enrich, trust);
        Preconditions.checkArgument((boolean)Objects.equals(merge.getSource(), enrich.getSource()), (Object)"source ids must be equal");
        Preconditions.checkArgument((boolean)Objects.equals(merge.getTarget(), enrich.getTarget()), (Object)"target ids must be equal");
        Preconditions.checkArgument((boolean)Objects.equals(merge.getRelType(), enrich.getRelType()), (Object)"relType(s) must be equal");
        Preconditions.checkArgument((boolean)Objects.equals(merge.getSubRelType(), enrich.getSubRelType()), (Object)"subRelType(s) must be equal");
        Preconditions.checkArgument((boolean)Objects.equals(merge.getRelClass(), enrich.getRelClass()), (Object)"relClass(es) must be equal");
        merge.setValidated(MergeUtils.booleanOR(merge.getValidated(), enrich.getValidated()));
        try {
            merge.setValidationDate(ModelSupport.oldest((String)merge.getValidationDate(), (String)enrich.getValidationDate()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("invalid validation date format in relation [s:%s, t:%s]: %s", merge.getSource(), merge.getTarget(), merge.getValidationDate()));
        }
        merge.setProperties(MergeUtils.mergeByKey(merge.getProperties(), enrich.getProperties(), trust));
        return merge;
    }

    private static <T extends Result> T mergeResultFields(T original, T enrich) {
        int trust = MergeUtils.compareTrust(original, enrich);
        T merge = MergeUtils.mergeOafEntityFields(original, enrich, trust);
        if (merge.getProcessingchargeamount() == null || StringUtils.isBlank((CharSequence)((CharSequence)merge.getProcessingchargeamount().getValue()))) {
            merge.setProcessingchargeamount(enrich.getProcessingchargeamount());
            merge.setProcessingchargecurrency(enrich.getProcessingchargecurrency());
        }
        merge.setAuthor(MergeUtils.mergeAuthors(merge.getAuthor(), enrich.getAuthor(), trust));
        if (merge.getResulttype() == null) {
            merge.setResulttype(enrich.getResulttype());
            merge.setMetaResourceType(enrich.getMetaResourceType());
        }
        merge.setLanguage(MergeUtils.coalesceQualifier(merge.getLanguage(), enrich.getLanguage()));
        merge.setCountry(MergeUtils.mergeQualifiers(merge.getCountry(), enrich.getCountry(), trust));
        merge.setSubject(MergeUtils.mergeStructuredProperties(merge.getSubject(), enrich.getSubject(), trust));
        merge.setTitle(MergeUtils.mergeStructuredProperties(merge.getTitle(), enrich.getTitle(), trust));
        merge.setRelevantdate(MergeUtils.mergeStructuredProperties(merge.getRelevantdate(), enrich.getRelevantdate(), trust));
        if (merge.getDescription() == null || merge.getDescription().isEmpty() || trust == 0) {
            merge.setDescription(MergeUtils.longestLists(merge.getDescription(), enrich.getDescription()));
        }
        merge.setDateofacceptance(MergeUtils.mergeDateOfAcceptance((Field<String>)merge.getDateofacceptance(), (Field<String>)enrich.getDateofacceptance(), trust));
        merge.setPublisher(MergeUtils.coalesce(merge.getPublisher(), enrich.getPublisher()));
        merge.setEmbargoenddate(MergeUtils.coalesce(merge.getEmbargoenddate(), enrich.getEmbargoenddate()));
        merge.setSource(MergeUtils.unionDistinctLists(merge.getSource(), enrich.getSource(), trust));
        merge.setFulltext(MergeUtils.unionDistinctLists(merge.getFulltext(), enrich.getFulltext(), trust));
        merge.setFormat(MergeUtils.unionDistinctLists(merge.getFormat(), enrich.getFormat(), trust));
        merge.setContributor(MergeUtils.unionDistinctLists(merge.getContributor(), enrich.getContributor(), trust));
        merge.setResourcetype(MergeUtils.coalesce(merge.getResourcetype(), enrich.getResourcetype()));
        merge.setCoverage(MergeUtils.unionDistinctLists(merge.getCoverage(), enrich.getCoverage(), trust));
        if (enrich.getBestaccessright() != null && new AccessRightComparator().compare(enrich.getBestaccessright(), merge.getBestaccessright()) < 0) {
            merge.setBestaccessright(enrich.getBestaccessright());
        }
        merge.setContext(MergeUtils.mergeLists(merge.getContext(), enrich.getContext(), trust, Context::getId, (r, l) -> {
            ArrayList infos = new ArrayList();
            infos.addAll(r.getDataInfo());
            infos.addAll(l.getDataInfo());
            r.setDataInfo(infos);
            return r;
        }));
        merge.setExternalReference(MergeUtils.mergeExternalReference(merge.getExternalReference(), enrich.getExternalReference(), trust));
        if (!MergeUtils.isAnEnrichment(merge) && !MergeUtils.isAnEnrichment(enrich)) {
            merge.setInstance(MergeUtils.mergeInstances(merge.getInstance(), enrich.getInstance(), trust));
        } else {
            List enrichedInstances;
            List enrichmentInstances = MergeUtils.isAnEnrichment(merge) ? merge.getInstance() : enrich.getInstance();
            List list = enrichedInstances = MergeUtils.isAnEnrichment(merge) ? enrich.getInstance() : merge.getInstance();
            if (MergeUtils.isAnEnrichment(merge)) {
                merge.setDataInfo(enrich.getDataInfo());
            }
            merge.setInstance(MergeUtils.enrichInstances(enrichedInstances, enrichmentInstances));
        }
        merge.setEoscifguidelines(MergeUtils.mergeEosciifguidelines(merge.getEoscifguidelines(), enrich.getEoscifguidelines(), trust));
        merge.setIsGreen(MergeUtils.booleanOR(merge.getIsGreen(), enrich.getIsGreen()));
        merge.setOpenAccessColor(MergeUtils.coalesce(merge.getOpenAccessColor(), enrich.getOpenAccessColor()));
        merge.setIsInDiamondJournal(MergeUtils.booleanOR(merge.getIsInDiamondJournal(), enrich.getIsInDiamondJournal()));
        merge.setPubliclyFunded(MergeUtils.booleanOR(merge.getPubliclyFunded(), enrich.getPubliclyFunded()));
        if (StringUtils.isBlank((CharSequence)merge.getTransformativeAgreement())) {
            merge.setTransformativeAgreement(enrich.getTransformativeAgreement());
        }
        return merge;
    }

    private static Field<String> mergeDateOfAcceptance(Field<String> merge, Field<String> enrich, int trust) {
        if ((merge == null || trust == 0) && enrich != null) {
            if (merge == null) {
                return enrich;
            }
            try {
                LocalDate merge_date = LocalDate.parse((CharSequence)merge.getValue(), DateTimeFormatter.ISO_DATE);
                try {
                    LocalDate enrich_date = LocalDate.parse((CharSequence)enrich.getValue(), DateTimeFormatter.ISO_DATE);
                    if (enrich_date.getYear() > 1300 && (merge_date.getYear() < 1300 || merge_date.isAfter(enrich_date))) {
                        return enrich;
                    }
                }
                catch (NullPointerException | DateTimeParseException e) {
                    return merge;
                }
            }
            catch (NullPointerException | DateTimeParseException e) {
                return enrich;
            }
        }
        return merge;
    }

    private static List<Instance> mergeInstances(List<Instance> v1, List<Instance> v2, int trust) {
        return MergeUtils.mergeLists(v1, v2, trust, MergeUtils::instanceKeyExtractor, MergeUtils::instanceMerger);
    }

    private static List<EoscIfGuidelines> mergeEosciifguidelines(List<EoscIfGuidelines> v1, List<EoscIfGuidelines> v2, int trust) {
        return MergeUtils.mergeLists(v1, v2, trust, er -> Joiner.on((String)"||").useForNull("").join((Object)er.getCode(), (Object)er.getLabel(), new Object[]{er.getUrl(), er.getSemanticRelation()}), (r, l) -> r);
    }

    private static List<ExternalReference> mergeExternalReference(List<ExternalReference> v1, List<ExternalReference> v2, int trust) {
        return MergeUtils.mergeLists(v1, v2, trust, er -> Joiner.on((char)',').useForNull("").join((Object)er.getSitename(), (Object)er.getLabel(), new Object[]{er.getUrl(), MergeUtils.toString(er.getQualifier()), er.getRefidentifier(), er.getQuery(), MergeUtils.toString(er.getDataInfo())}), (r, l) -> r);
    }

    private static String toString(DataInfo di) {
        return Joiner.on((char)',').useForNull("").join((Object)di.getInvisible(), (Object)di.getInferred(), new Object[]{di.getDeletedbyinference(), di.getTrust(), di.getInferenceprovenance(), MergeUtils.toString(di.getProvenanceaction())});
    }

    private static String toString(Qualifier q) {
        return Joiner.on((char)',').useForNull("").join((Object)q.getClassid(), (Object)q.getClassname(), new Object[]{q.getSchemeid(), q.getSchemename()});
    }

    private static String toString(StructuredProperty sp2) {
        return Joiner.on((char)',').useForNull("").join((Object)MergeUtils.toString(sp2.getQualifier()), (Object)sp2.getValue(), new Object[0]);
    }

    private static <T extends StructuredProperty> List<T> mergeStructuredProperties(List<T> v1, List<T> v2, int trust) {
        return MergeUtils.mergeLists(v1, v2, trust, MergeUtils::toString, (r, l) -> r);
    }

    private static <T extends Qualifier> List<T> mergeQualifiers(List<T> v1, List<T> v2, int trust) {
        return MergeUtils.mergeLists(v1, v2, trust, MergeUtils::toString, (r, l) -> r);
    }

    private static <T> T coalesce(T m, T e) {
        return m != null ? m : e;
    }

    private static Qualifier coalesceQualifier(Qualifier m, Qualifier e) {
        if (m == null || m.getClassid() == null || StringUtils.isBlank((CharSequence)m.getClassid())) {
            return e;
        }
        return m;
    }

    private static List<Author> mergeAuthors(List<Author> author, List<Author> author1, int trust) {
        ArrayList<List<Author>> authors = new ArrayList<List<Author>>();
        if (author != null) {
            authors.add(author);
        }
        if (author1 != null) {
            authors.add(author1);
        }
        return AuthorMerger.merge(authors);
    }

    private static String instanceKeyExtractor(Instance i) {
        return String.join((CharSequence)"::", MergeUtils.kvKeyExtractor(i.getHostedby()), MergeUtils.kvKeyExtractor(i.getCollectedfrom()), MergeUtils.qualifierKeyExtractor((Qualifier)i.getAccessright()), MergeUtils.qualifierKeyExtractor(i.getInstancetype()), Optional.ofNullable(i.getUrl()).map(u -> String.join((CharSequence)"@@", u)).orElse(null), Optional.ofNullable(i.getPid()).map(pp -> pp.stream().map(MergeUtils::spKeyExtractor).collect(Collectors.joining("@@"))).orElse(null));
    }

    private static Instance instanceMerger(Instance i1, Instance i2) {
        Instance i = new Instance();
        i.setHostedby(i1.getHostedby());
        i.setCollectedfrom(i1.getCollectedfrom());
        i.setAccessright(i1.getAccessright());
        i.setInstancetype(i1.getInstancetype());
        i.setPid(MergeUtils.mergeLists(i1.getPid(), i2.getPid(), 0, MergeUtils::spKeyExtractor, (sp1, sp2) -> sp1));
        i.setAlternateIdentifier(MergeUtils.mergeLists(i1.getAlternateIdentifier(), i2.getAlternateIdentifier(), 0, MergeUtils::spKeyExtractor, (sp1, sp2) -> sp1));
        i.setRefereed(Collections.min(Stream.of(i1.getRefereed(), i2.getRefereed()).collect(Collectors.toList()), new RefereedComparator()));
        i.setInstanceTypeMapping(MergeUtils.mergeLists(i1.getInstanceTypeMapping(), i2.getInstanceTypeMapping(), 0, MergeUtils::instanceTypeMappingKeyExtractor, (itm1, itm2) -> itm1));
        i.setFulltext(MergeUtils.selectFulltext(i1.getFulltext(), i2.getFulltext()));
        i.setDateofacceptance(MergeUtils.selectOldestDate((Field<String>)i1.getDateofacceptance(), (Field<String>)i2.getDateofacceptance()));
        i.setLicense(MergeUtils.coalesce(i1.getLicense(), i2.getLicense()));
        i.setProcessingchargeamount(MergeUtils.coalesce(i1.getProcessingchargeamount(), i2.getProcessingchargeamount()));
        i.setProcessingchargecurrency(MergeUtils.coalesce(i1.getProcessingchargecurrency(), i2.getProcessingchargecurrency()));
        i.setMeasures(MergeUtils.mergeLists(i1.getMeasures(), i2.getMeasures(), 0, MergeUtils::measureKeyExtractor, (m1, m2) -> m1));
        i.setUrl(MergeUtils.unionDistinctListOfString(i1.getUrl(), i2.getUrl()));
        return i;
    }

    private static String measureKeyExtractor(Measure m) {
        return String.join((CharSequence)"::", m.getId(), m.getUnit().stream().map(KeyValue::getKey).collect(Collectors.joining("::")));
    }

    private static Field<String> selectOldestDate(Field<String> d1, Field<String> d2) {
        if (!GraphCleaningFunctions.cleanDateField(d1).isPresent()) {
            return d2;
        }
        if (!GraphCleaningFunctions.cleanDateField(d2).isPresent()) {
            return d1;
        }
        return Stream.of(d1, d2).min(Comparator.comparing(f -> DateParserUtils.parseDate((String)((String)f.getValue())).toInstant().atZone(ZoneId.systemDefault()).toLocalDate())).orElse(d1);
    }

    private static String selectFulltext(String ft1, String ft2) {
        if (StringUtils.endsWith((CharSequence)ft1, (CharSequence)"pdf")) {
            return ft1;
        }
        if (StringUtils.endsWith((CharSequence)ft2, (CharSequence)"pdf")) {
            return ft2;
        }
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{ft1, ft2});
    }

    private static String instanceTypeMappingKeyExtractor(InstanceTypeMapping itm) {
        return String.join((CharSequence)"::", itm.getOriginalType(), itm.getTypeCode(), itm.getTypeLabel(), itm.getVocabularyName());
    }

    private static String kvKeyExtractor(KeyValue kv) {
        return Optional.ofNullable(kv).map(KeyValue::getKey).orElse(null);
    }

    private static String qualifierKeyExtractor(Qualifier q) {
        return Optional.ofNullable(q).map(Qualifier::getClassid).orElse(null);
    }

    private static <T> T fieldKeyExtractor(Field<T> f) {
        return Optional.ofNullable(f).map(Field::getValue).orElse(null);
    }

    private static String spKeyExtractor(StructuredProperty sp2) {
        return Optional.ofNullable(sp2).map(s -> Joiner.on((String)"||").useForNull("").join((Object)MergeUtils.qualifierKeyExtractor(s.getQualifier()), (Object)s.getValue(), new Object[0])).orElse(null);
    }

    private static <T extends OtherResearchProduct> T mergeORP(T original, T enrich) {
        int trust = MergeUtils.compareTrust(original, enrich);
        T merge = MergeUtils.mergeResultFields(original, enrich);
        merge.setContactperson(MergeUtils.unionDistinctLists(merge.getContactperson(), enrich.getContactperson(), trust));
        merge.setContactgroup(MergeUtils.unionDistinctLists(merge.getContactgroup(), enrich.getContactgroup(), trust));
        merge.setTool(MergeUtils.unionDistinctLists(merge.getTool(), enrich.getTool(), trust));
        return merge;
    }

    private static <T extends Software> T mergeSoftware(T original, T enrich) {
        int trust = MergeUtils.compareTrust(original, enrich);
        T merge = MergeUtils.mergeResultFields(original, enrich);
        merge.setDocumentationUrl(MergeUtils.unionDistinctLists(merge.getDocumentationUrl(), enrich.getDocumentationUrl(), trust));
        merge.setLicense(MergeUtils.unionDistinctLists(merge.getLicense(), enrich.getLicense(), trust));
        merge.setCodeRepositoryUrl(MergeUtils.chooseReference(merge.getCodeRepositoryUrl(), enrich.getCodeRepositoryUrl(), trust));
        merge.setProgrammingLanguage(MergeUtils.chooseReference(merge.getProgrammingLanguage(), enrich.getProgrammingLanguage(), trust));
        return merge;
    }

    private static <T extends Dataset> T mergeDataset(T original, T enrich) {
        int trust = MergeUtils.compareTrust(original, enrich);
        T merge = MergeUtils.mergeResultFields(original, enrich);
        merge.setStoragedate(MergeUtils.chooseReference(merge.getStoragedate(), enrich.getStoragedate(), trust));
        merge.setDevice(MergeUtils.chooseReference(merge.getDevice(), enrich.getDevice(), trust));
        merge.setSize(MergeUtils.chooseReference(merge.getSize(), enrich.getSize(), trust));
        merge.setVersion(MergeUtils.chooseReference(merge.getVersion(), enrich.getVersion(), trust));
        merge.setLastmetadataupdate(MergeUtils.chooseReference(merge.getLastmetadataupdate(), enrich.getLastmetadataupdate(), trust));
        merge.setMetadataversionnumber(MergeUtils.chooseReference(merge.getMetadataversionnumber(), enrich.getMetadataversionnumber(), trust));
        merge.setGeolocation(MergeUtils.unionDistinctLists(merge.getGeolocation(), enrich.getGeolocation(), trust));
        return merge;
    }

    public static <T extends Publication> T mergePublication(T original, T enrich) {
        int trust = MergeUtils.compareTrust(original, enrich);
        T merged = MergeUtils.mergeResultFields(original, enrich);
        merged.setJournal(MergeUtils.chooseReference(merged.getJournal(), enrich.getJournal(), trust));
        return merged;
    }

    private static <T extends Organization> T mergeOrganization(T left, T enrich) {
        int trust = MergeUtils.compareTrust(left, enrich);
        T merged = MergeUtils.mergeOafEntityFields(left, enrich, trust);
        merged.setLegalshortname(MergeUtils.chooseReference(merged.getLegalshortname(), enrich.getLegalshortname(), trust));
        merged.setLegalname(MergeUtils.chooseReference(merged.getLegalname(), enrich.getLegalname(), trust));
        merged.setAlternativeNames(MergeUtils.unionDistinctLists(enrich.getAlternativeNames(), merged.getAlternativeNames(), trust));
        merged.setWebsiteurl(MergeUtils.chooseReference(merged.getWebsiteurl(), enrich.getWebsiteurl(), trust));
        merged.setLogourl(MergeUtils.chooseReference(merged.getLogourl(), enrich.getLogourl(), trust));
        merged.setEclegalbody(MergeUtils.chooseReference(merged.getEclegalbody(), enrich.getEclegalbody(), trust));
        merged.setEclegalperson(MergeUtils.chooseReference(merged.getEclegalperson(), enrich.getEclegalperson(), trust));
        merged.setEcnonprofit(MergeUtils.chooseReference(merged.getEcnonprofit(), enrich.getEcnonprofit(), trust));
        merged.setEcresearchorganization(MergeUtils.chooseReference(merged.getEcresearchorganization(), enrich.getEcresearchorganization(), trust));
        merged.setEchighereducation(MergeUtils.chooseReference(merged.getEchighereducation(), enrich.getEchighereducation(), trust));
        merged.setEcinternationalorganizationeurinterests(MergeUtils.chooseReference(merged.getEcinternationalorganizationeurinterests(), enrich.getEcinternationalorganizationeurinterests(), trust));
        merged.setEcinternationalorganization(MergeUtils.chooseReference(merged.getEcinternationalorganization(), enrich.getEcinternationalorganization(), trust));
        merged.setEcenterprise(MergeUtils.chooseReference(merged.getEcenterprise(), enrich.getEcenterprise(), trust));
        merged.setEcsmevalidated(MergeUtils.chooseReference(merged.getEcsmevalidated(), enrich.getEcsmevalidated(), trust));
        merged.setEcnutscode(MergeUtils.chooseReference(merged.getEcnutscode(), enrich.getEcnutscode(), trust));
        merged.setCountry(MergeUtils.chooseReference(merged.getCountry(), enrich.getCountry(), trust));
        return merged;
    }

    public static <T extends Project> T mergeProject(T original, T enrich) {
        int trust = MergeUtils.compareTrust(original, enrich);
        T merged = MergeUtils.mergeOafEntityFields(original, enrich, trust);
        merged.setWebsiteurl(MergeUtils.chooseReference(merged.getWebsiteurl(), enrich.getWebsiteurl(), trust));
        merged.setCode(MergeUtils.chooseReference(merged.getCode(), enrich.getCode(), trust));
        merged.setAcronym(MergeUtils.chooseReference(merged.getAcronym(), enrich.getAcronym(), trust));
        merged.setTitle(MergeUtils.chooseReference(merged.getTitle(), enrich.getTitle(), trust));
        merged.setStartdate(MergeUtils.chooseReference(merged.getStartdate(), enrich.getStartdate(), trust));
        merged.setEnddate(MergeUtils.chooseReference(merged.getEnddate(), enrich.getEnddate(), trust));
        merged.setCallidentifier(MergeUtils.chooseReference(merged.getCallidentifier(), enrich.getCallidentifier(), trust));
        merged.setKeywords(MergeUtils.chooseReference(merged.getKeywords(), enrich.getKeywords(), trust));
        merged.setDuration(MergeUtils.chooseReference(merged.getDuration(), enrich.getDuration(), trust));
        merged.setEcsc39(MergeUtils.chooseReference(merged.getEcsc39(), enrich.getEcsc39(), trust));
        merged.setOamandatepublications(MergeUtils.chooseReference(merged.getOamandatepublications(), enrich.getOamandatepublications(), trust));
        merged.setEcarticle29_3(MergeUtils.chooseReference(merged.getEcarticle29_3(), enrich.getEcarticle29_3(), trust));
        merged.setSubjects(MergeUtils.unionDistinctLists(merged.getSubjects(), enrich.getSubjects(), trust));
        merged.setFundingtree(MergeUtils.unionDistinctLists(merged.getFundingtree(), enrich.getFundingtree(), trust));
        merged.setContracttype(MergeUtils.chooseReference(merged.getContracttype(), enrich.getContracttype(), trust));
        merged.setOptional1(MergeUtils.chooseReference(merged.getOptional1(), enrich.getOptional1(), trust));
        merged.setOptional2(MergeUtils.chooseReference(merged.getOptional2(), enrich.getOptional2(), trust));
        merged.setJsonextrainfo(MergeUtils.chooseReference(merged.getJsonextrainfo(), enrich.getJsonextrainfo(), trust));
        merged.setContactfullname(MergeUtils.chooseReference(merged.getContactfullname(), enrich.getContactfullname(), trust));
        merged.setContactfax(MergeUtils.chooseReference(merged.getContactfax(), enrich.getContactfax(), trust));
        merged.setContactphone(MergeUtils.chooseReference(merged.getContactphone(), enrich.getContactphone(), trust));
        merged.setContactemail(MergeUtils.chooseReference(merged.getContactemail(), enrich.getContactemail(), trust));
        merged.setSummary(MergeUtils.chooseReference(merged.getSummary(), enrich.getSummary(), trust));
        merged.setCurrency(MergeUtils.chooseReference(merged.getCurrency(), enrich.getCurrency(), trust));
        merged.setTotalcost(MergeUtils.chooseReference(merged.getTotalcost(), enrich.getTotalcost(), trust));
        merged.setFundedamount(MergeUtils.chooseReference(merged.getFundedamount(), enrich.getFundedamount(), trust));
        if (enrich.getH2020topiccode() != null && StringUtils.isEmpty((CharSequence)merged.getH2020topiccode())) {
            merged.setH2020topiccode(enrich.getH2020topiccode());
            merged.setH2020topicdescription(enrich.getH2020topicdescription());
        }
        merged.setH2020classification(MergeUtils.unionDistinctLists(merged.getH2020classification(), enrich.getH2020classification(), trust));
        return merged;
    }

    private static List<Field<String>> longestLists(List<Field<String>> a, List<Field<String>> b) {
        if (a == null || b == null) {
            return a == null ? b : a;
        }
        return a.size() >= b.size() ? a : b;
    }

    private static List<Instance> enrichInstances(List<Instance> toEnrichInstances, List<Instance> enrichmentInstances) {
        ArrayList<Instance> enrichmentResult = new ArrayList<Instance>();
        if (toEnrichInstances == null) {
            return enrichmentResult;
        }
        if (enrichmentInstances == null || enrichmentInstances.isEmpty()) {
            return toEnrichInstances;
        }
        Map<String, Instance> ri = MergeUtils.toInstanceMap(enrichmentInstances);
        toEnrichInstances.forEach(i -> {
            List<Instance> e = MergeUtils.findEnrichmentsByPID(i.getPid(), ri);
            if (e != null && e.size() > 0) {
                e.forEach(enr -> MergeUtils.applyEnrichment(i, enr));
            } else {
                List<Instance> a = MergeUtils.findEnrichmentsByPID(i.getAlternateIdentifier(), ri);
                if (a != null && a.size() > 0) {
                    a.forEach(enr -> MergeUtils.applyEnrichment(i, enr));
                }
            }
            enrichmentResult.add((Instance)i);
        });
        return enrichmentResult;
    }

    private static Map<String, Instance> toInstanceMap(List<Instance> ri) {
        return ri.stream().filter(i -> i.getPid() != null || i.getAlternateIdentifier() != null).flatMap(i -> {
            ArrayList result = new ArrayList();
            if (i.getPid() != null) {
                i.getPid().stream().filter(MergeUtils::validPid).forEach(p -> result.add(new ImmutablePair((Object)MergeUtils.extractKeyFromPid(p), i)));
            }
            if (i.getAlternateIdentifier() != null) {
                i.getAlternateIdentifier().stream().filter(MergeUtils::validPid).forEach(p -> result.add(new ImmutablePair((Object)MergeUtils.extractKeyFromPid(p), i)));
            }
            return result.stream();
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (a, b) -> a));
    }

    private static boolean isFromDelegatedAuthority(Result r) {
        return Optional.ofNullable(r.getInstance()).map(instance -> instance.stream().filter(i -> Objects.nonNull(i.getCollectedfrom())).map(i -> i.getCollectedfrom().getKey()).anyMatch(cfId -> IdentifierFactory.delegatedAuthorityDatasourceIds().contains(cfId))).orElse(false);
    }

    private static boolean validPid(StructuredProperty p) {
        return p.getValue() != null && p.getQualifier() != null && p.getQualifier().getClassid() != null;
    }

    private static String extractKeyFromPid(StructuredProperty pid) {
        if (pid == null) {
            return null;
        }
        StructuredProperty normalizedPid = PidCleaner.normalizePidValue(pid);
        return String.format("%s::%s", normalizedPid.getQualifier().getClassid(), normalizedPid.getValue());
    }

    private static List<Instance> findEnrichmentsByPID(List<StructuredProperty> pids, Map<String, Instance> enrichments) {
        if (pids == null || enrichments == null) {
            return null;
        }
        return pids.stream().map(MergeUtils::extractKeyFromPid).map(enrichments::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static boolean isAnEnrichment(OafEntity e) {
        return e.getDataInfo() != null && e.getDataInfo().getProvenanceaction() != null && "sysimport:enrich".equalsIgnoreCase(e.getDataInfo().getProvenanceaction().getClassid());
    }

    private static void applyEnrichment(Instance merge, Instance enrichment) {
        if (merge == null || enrichment == null) {
            return;
        }
        merge.setLicense((Field)ObjectUtils.firstNonNull((Object[])new Field[]{merge.getLicense(), enrichment.getLicense()}));
        merge.setAccessright((AccessRight)ObjectUtils.firstNonNull((Object[])new AccessRight[]{merge.getAccessright(), enrichment.getAccessright()}));
        merge.setInstancetype((Qualifier)ObjectUtils.firstNonNull((Object[])new Qualifier[]{merge.getInstancetype(), enrichment.getInstancetype()}));
        merge.setInstanceTypeMapping((List)ObjectUtils.firstNonNull((Object[])new List[]{merge.getInstanceTypeMapping(), enrichment.getInstanceTypeMapping()}));
        merge.setHostedby((KeyValue)ObjectUtils.firstNonNull((Object[])new KeyValue[]{merge.getHostedby(), enrichment.getHostedby()}));
        merge.setUrl(MergeUtils.unionDistinctLists(merge.getUrl(), enrichment.getUrl(), 0));
        merge.setDistributionlocation((String)ObjectUtils.firstNonNull((Object[])new String[]{merge.getDistributionlocation(), enrichment.getDistributionlocation()}));
        merge.setCollectedfrom((KeyValue)ObjectUtils.firstNonNull((Object[])new KeyValue[]{merge.getCollectedfrom(), enrichment.getCollectedfrom()}));
        merge.setDateofacceptance((Field)ObjectUtils.firstNonNull((Object[])new Field[]{merge.getDateofacceptance(), enrichment.getDateofacceptance()}));
        merge.setProcessingchargeamount((Field)ObjectUtils.firstNonNull((Object[])new Field[]{merge.getProcessingchargeamount(), enrichment.getProcessingchargeamount()}));
        merge.setProcessingchargecurrency((Field)ObjectUtils.firstNonNull((Object[])new Field[]{merge.getProcessingchargecurrency(), enrichment.getProcessingchargecurrency()}));
        merge.setRefereed((Qualifier)ObjectUtils.firstNonNull((Object[])new Qualifier[]{merge.getRefereed(), enrichment.getRefereed()}));
        merge.setMeasures(MergeUtils.unionDistinctLists(merge.getMeasures(), enrichment.getMeasures(), 0));
        merge.setFulltext((String)ObjectUtils.firstNonNull((Object[])new String[]{merge.getFulltext(), enrichment.getFulltext()}));
    }

    private static int compareTrust(Oaf a, Oaf b) {
        String left = Optional.ofNullable(a.getDataInfo()).map(DataInfo::getTrust).orElse("0.0");
        String right = Optional.ofNullable(b.getDataInfo()).map(DataInfo::getTrust).orElse("0.0");
        return left.compareTo(right);
    }
}

