/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common;

import com.google.common.collect.Iterables;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.QueryBuilder;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Sorts;
import eu.dnetlib.dhp.common.MDStoreInfo;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdstoreClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MdstoreClient.class);
    private final MongoClient client;
    private final MongoDatabase db;
    private static final String COLL_METADATA = "metadata";
    private static final String COLL_METADATA_MANAGER = "metadataManager";

    public MdstoreClient(String baseUrl, String dbName) {
        this.client = new MongoClient(new MongoClientURI(baseUrl));
        this.db = this.getDb(this.client, dbName);
    }

    private Long parseTimestamp(Document f) {
        if (f == null || !f.containsKey((Object)"timestamp")) {
            return null;
        }
        Object ts = f.get((Object)"timestamp");
        return Long.parseLong(ts.toString());
    }

    public Long getLatestTimestamp(String collectionId) {
        MongoCollection collection = this.db.getCollection(collectionId);
        FindIterable result = collection.find().sort(Sorts.descending((String[])new String[]{"timestamp"})).limit(1);
        if (result == null) {
            return null;
        }
        Document f = (Document)result.first();
        return this.parseTimestamp(f);
    }

    public MongoCollection<Document> mdStore(String mdId) {
        BasicDBObject query = (BasicDBObject)QueryBuilder.start((String)"mdId").is((Object)mdId).get();
        log.info("querying current mdId: {}", (Object)query.toJson());
        String currentId = Optional.ofNullable(this.getColl(this.db, COLL_METADATA_MANAGER, true).find((Bson)query)).map(MongoIterable::first).map(d -> d.getString((Object)"currentId")).orElseThrow(() -> new IllegalArgumentException("cannot find current mdstore id for: " + mdId));
        log.info("currentId: {}", (Object)currentId);
        return this.getColl(this.db, currentId, true);
    }

    public List<MDStoreInfo> mdStoreWithTimestamp(String mdFormat, String mdLayout, String mdInterpretation) {
        Map<String, String> res = this.validCollections(mdFormat, mdLayout, mdInterpretation);
        return res.entrySet().stream().map(e -> new MDStoreInfo((String)e.getKey(), (String)e.getValue(), this.getLatestTimestamp((String)e.getValue()))).collect(Collectors.toList());
    }

    public Map<String, String> validCollections(String mdFormat, String mdLayout, String mdInterpretation) {
        HashMap<String, String> transactions = new HashMap<String, String>();
        for (Document entry : this.getColl(this.db, COLL_METADATA_MANAGER, true).find()) {
            String currentId;
            String mdId = entry.getString((Object)"mdId");
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mdId, currentId = entry.getString((Object)"currentId")})) continue;
            transactions.put(mdId, currentId);
        }
        HashMap<String, String> res = new HashMap<String, String>();
        for (Document entry : this.getColl(this.db, COLL_METADATA, true).find()) {
            if (!entry.getString((Object)"format").equals(mdFormat) || !entry.getString((Object)"layout").equals(mdLayout) || !entry.getString((Object)"interpretation").equals(mdInterpretation) || !transactions.containsKey(entry.getString((Object)"mdId"))) continue;
            res.put(entry.getString((Object)"mdId"), (String)transactions.get(entry.getString((Object)"mdId")));
        }
        return res;
    }

    private MongoDatabase getDb(MongoClient client, String dbName) {
        if (!Iterables.contains((Iterable)client.listDatabaseNames(), (Object)dbName)) {
            String err = String.format("Database '%s' not found in %s", dbName, client.getAddress());
            log.warn(err);
            throw new IllegalArgumentException(err);
        }
        return client.getDatabase(dbName);
    }

    private MongoCollection<Document> getColl(MongoDatabase db, String collName, boolean abortIfMissing) {
        if (!Iterables.contains((Iterable)db.listCollectionNames(), (Object)collName)) {
            String err = String.format(String.format("Missing collection '%s' in database '%s'", collName, db.getName()), new Object[0]);
            log.warn(err);
            if (abortIfMissing) {
                throw new IllegalArgumentException(err);
            }
            return null;
        }
        return db.getCollection(collName);
    }

    public Iterable<String> listRecords(String collName) {
        MongoCollection<Document> coll = this.getColl(this.db, collName, false);
        return coll == null ? new ArrayList() : () -> StreamSupport.stream(coll.find().spliterator(), false).filter(e -> e.containsKey((Object)"body")).map(e -> e.getString((Object)"body")).iterator();
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

