/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.merge;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanFolderSparkJob {
    private static final Logger log = LoggerFactory.getLogger(CleanFolderSparkJob.class);
    private ArgumentApplicationParser parser;

    public CleanFolderSparkJob(ArgumentApplicationParser parser) {
        this.parser = parser;
    }

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)CleanFolderSparkJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/merge/clean_folder_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        new CleanFolderSparkJob(parser).run(isSparkSessionManaged);
    }

    public void run(Boolean isSparkSessionManaged) throws ISLookUpException {
        String deletePath = this.parser.get("deletePath");
        log.info("deletePath: {}", (Object)deletePath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession(conf, isSparkSessionManaged, spark -> HdfsSupport.remove(deletePath, new Configuration()));
    }
}

