/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.index.es;

import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.util.BinaryData;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConvertJSONWithId
implements Function<String, BulkOperation> {
    private final Pattern idRegEx;
    private final String indexName;

    private String search(String text, Pattern pattern) {
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public ConvertJSONWithId(String regxId, String indexName) {
        this.idRegEx = Pattern.compile(regxId);
        this.indexName = indexName;
    }

    @Override
    public BulkOperation apply(String json) {
        String id = this.search(json, this.idRegEx);
        return (BulkOperation)new BulkOperation.Builder().index(i -> ((IndexOperation.Builder)((IndexOperation.Builder)i.index(this.indexName)).id(id)).document((Object)BinaryData.of((byte[])json.getBytes(StandardCharsets.UTF_8), (String)"application/json"))).build();
    }
}

