/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.collection;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DecompressTarGz {
    public static void doExtract(FileSystem fs, String outputPath, String tarGzPath) throws IOException {
        FSDataInputStream inputFileStream = fs.open(new Path(tarGzPath));
        try (TarArchiveInputStream tais = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)inputFileStream));){
            TarArchiveEntry entry = null;
            while ((entry = tais.getNextTarEntry()) != null) {
                if (entry.isDirectory()) continue;
                FSDataOutputStream out = fs.create(new Path(outputPath.concat(entry.getName()).concat(".gz")));
                try (GZIPOutputStream gzipOs = new GZIPOutputStream(new BufferedOutputStream((OutputStream)out));){
                    IOUtils.copy((InputStream)tais, (OutputStream)gzipOs);
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
        }
    }
}

