/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.merge;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyEntitiesSparkJob {
    private static final Logger log = LoggerFactory.getLogger(CopyEntitiesSparkJob.class);
    private ArgumentApplicationParser parser;

    public CopyEntitiesSparkJob(ArgumentApplicationParser parser) {
        this.parser = parser;
    }

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)CopyEntitiesSparkJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/merge/copy_graph_entities_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        new CopyEntitiesSparkJob(parser).run(isSparkSessionManaged);
    }

    public void run(Boolean isSparkSessionManaged) throws ISLookUpException {
        String graphInputPath = this.parser.get("graphInputPath");
        log.info("graphInputPath: {}", (Object)graphInputPath);
        String outputPath = this.parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String entities = this.parser.get("entities");
        log.info("entities: {}", (Object)entities);
        String format = this.parser.get("format");
        log.info("format: {}", (Object)format);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession(conf, isSparkSessionManaged, spark -> Arrays.stream(entities.split(",")).map(x -> x.trim().toLowerCase()).filter(ModelSupport.oafTypes::containsKey).forEachOrdered(entity -> {
            switch (format.toLowerCase()) {
                case "text": {
                    spark.read().text(graphInputPath + "/" + entity).write().option("compression", "gzip").mode("overwrite").text(outputPath + "/" + entity);
                    break;
                }
                case "json": {
                    spark.read().json(graphInputPath + "/" + entity).write().option("compression", "gzip").mode("overwrite").json(outputPath + "/" + entity);
                    break;
                }
                case "parquet": {
                    spark.read().parquet(graphInputPath + "/" + entity).write().option("compression", "gzip").mode("overwrite").parquet(outputPath + "/" + entity);
                }
            }
        }));
    }
}

