/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class QNameCache {
    protected ThreadLocal<Map<String, QName>> noNamespaceCache = ThreadLocal.withInitial(WeakHashMap::new);
    protected ThreadLocal<Map<Namespace, Map<String, QName>>> namespaceCache = ThreadLocal.withInitial(WeakHashMap::new);
    private DocumentFactory documentFactory;

    public QNameCache() {
    }

    public QNameCache(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public List getQNames() {
        ArrayList<QName> answer = new ArrayList<QName>();
        answer.addAll(this.noNamespaceCache.get().values());
        for (Map<String, QName> map : this.namespaceCache.get().values()) {
            answer.addAll(map.values());
        }
        return answer;
    }

    public QName get(String name) {
        QName answer = null;
        if (name != null) {
            answer = this.noNamespaceCache.get().get(name);
        } else {
            name = "";
        }
        if (answer == null) {
            answer = this.createQName(name);
            answer.setDocumentFactory(this.documentFactory);
            this.noNamespaceCache.get().put(name, answer);
        }
        return answer;
    }

    public QName get(String name, Namespace namespace) {
        Map cache = this.getNamespaceCache(namespace);
        QName answer = null;
        if (name != null) {
            answer = (QName)cache.get(name);
        } else {
            name = "";
        }
        if (answer == null) {
            answer = this.createQName(name, namespace);
            answer.setDocumentFactory(this.documentFactory);
            cache.put(name, answer);
        }
        return answer;
    }

    public QName get(String localName, Namespace namespace, String qName) {
        Map cache = this.getNamespaceCache(namespace);
        QName answer = null;
        if (localName != null) {
            answer = (QName)cache.get(localName);
        } else {
            localName = "";
        }
        if (answer == null) {
            answer = this.createQName(localName, namespace, qName);
            answer.setDocumentFactory(this.documentFactory);
            cache.put(localName, answer);
        }
        return answer;
    }

    public QName get(String qualifiedName, String uri) {
        int index = qualifiedName.indexOf(58);
        if (index < 0) {
            return this.get(qualifiedName, Namespace.get((String)uri));
        }
        String name = qualifiedName.substring(index + 1);
        String prefix = qualifiedName.substring(0, index);
        return this.get(name, Namespace.get((String)prefix, (String)uri));
    }

    public QName intern(QName qname) {
        return this.get(qname.getName(), qname.getNamespace(), qname.getQualifiedName());
    }

    protected Map getNamespaceCache(Namespace namespace) {
        if (namespace == Namespace.NO_NAMESPACE) {
            return this.noNamespaceCache.get();
        }
        Map<String, QName> answer = null;
        if (namespace != null) {
            answer = this.namespaceCache.get().get(namespace);
        }
        if (answer == null) {
            answer = this.createMap();
            this.namespaceCache.get().put(namespace, answer);
        }
        return answer;
    }

    protected Map createMap() {
        return new HashMap();
    }

    protected QName createQName(String name) {
        return new QName(name);
    }

    protected QName createQName(String name, Namespace namespace) {
        return new QName(name, namespace);
    }

    protected QName createQName(String name, Namespace namespace, String qualifiedName) {
        return new QName(name, namespace, qualifiedName);
    }
}

