/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph.scholix;

import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixCollectedFrom;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixIdentifier;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixRelationship;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixResource;
import eu.dnetlib.dhp.schema.sx.summary.CollectedFromType;
import eu.dnetlib.dhp.schema.sx.summary.SchemeValue;
import eu.dnetlib.dhp.schema.sx.summary.ScholixSummary;
import eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Serializable;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.expressions.Aggregator;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ScholixUtils$
implements Serializable {
    public static final ScholixUtils$ MODULE$ = new ScholixUtils$();
    private static final String DNET_IDENTIFIER_SCHEMA = "DNET Identifier";
    private static final String DATE_RELATION_KEY = "RelationDate";
    private static final Map<String, ScholixUtils.RelationVocabulary> relations;
    private static final Aggregator<Tuple3<String, String, Object>, ScholixUtils.RelatedEntities, ScholixUtils.RelatedEntities> statsAggregator;
    private static final Aggregator<Tuple2<String, Scholix>, Scholix, Scholix> scholixAggregator;

    static {
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        String input = Source$.MODULE$.fromInputStream(MODULE$.getClass().getResourceAsStream("/eu/dnetlib/scholexplorer/relation/relations.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        relations = (Map)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(ScholixUtils$.json$1(json$lzy, input)), (Formats)ScholixUtils$.formats$1(formats$lzy), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(ScholixUtils.RelationVocabulary.class)})));
        statsAggregator = new Aggregator<Tuple3<String, String, Object>, ScholixUtils.RelatedEntities, ScholixUtils.RelatedEntities>(){

            public ScholixUtils.RelatedEntities zero() {
                return null;
            }

            public ScholixUtils.RelatedEntities reduce(ScholixUtils.RelatedEntities b, Tuple3<String, String, Object> a) {
                long relatedPublication;
                long relatedDataset = "dataset".equalsIgnoreCase((String)a._2()) ? BoxesRunTime.unboxToLong((Object)a._3()) : 0L;
                long l = relatedPublication = "publication".equalsIgnoreCase((String)a._2()) ? BoxesRunTime.unboxToLong((Object)a._3()) : 0L;
                if (b == null) {
                    return new ScholixUtils.RelatedEntities((String)a._1(), relatedDataset, relatedPublication);
                }
                return new ScholixUtils.RelatedEntities((String)a._1(), b.relatedDataset() + relatedDataset, b.relatedPublication() + relatedPublication);
            }

            public ScholixUtils.RelatedEntities merge(ScholixUtils.RelatedEntities b1, ScholixUtils.RelatedEntities b2) {
                if (b1 != null && b2 != null) {
                    return new ScholixUtils.RelatedEntities(b1.id(), b1.relatedDataset() + b2.relatedDataset(), b1.relatedPublication() + b2.relatedPublication());
                }
                if (b1 != null) {
                    return b1;
                }
                return b2;
            }

            public ScholixUtils.RelatedEntities finish(ScholixUtils.RelatedEntities reduction) {
                return reduction;
            }

            public Encoder<ScholixUtils.RelatedEntities> bufferEncoder() {
                return Encoders$.MODULE$.bean(ScholixUtils.RelatedEntities.class);
            }

            public Encoder<ScholixUtils.RelatedEntities> outputEncoder() {
                return Encoders$.MODULE$.bean(ScholixUtils.RelatedEntities.class);
            }
        };
        scholixAggregator = new Aggregator<Tuple2<String, Scholix>, Scholix, Scholix>(){

            public Scholix zero() {
                return null;
            }

            private boolean scholix_complete(Scholix s) {
                if (s == null || s.getIdentifier() == null) {
                    return false;
                }
                if (s.getSource() == null || s.getTarget() == null) {
                    return false;
                }
                return s.getLinkprovider() != null && !s.getLinkprovider().isEmpty();
            }

            public Scholix reduce(Scholix b, Tuple2<String, Scholix> a) {
                if (this.scholix_complete(b)) {
                    return b;
                }
                return (Scholix)a._2();
            }

            public Scholix merge(Scholix b1, Scholix b2) {
                if (this.scholix_complete(b1)) {
                    return b1;
                }
                return b2;
            }

            public Scholix finish(Scholix reduction) {
                return reduction;
            }

            public Encoder<Scholix> bufferEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Scholix.class));
            }

            public Encoder<Scholix> outputEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Scholix.class));
            }
        };
    }

    public String DNET_IDENTIFIER_SCHEMA() {
        return DNET_IDENTIFIER_SCHEMA;
    }

    public String DATE_RELATION_KEY() {
        return DATE_RELATION_KEY;
    }

    public Map<String, ScholixUtils.RelationVocabulary> relations() {
        return relations;
    }

    public String extractRelationDate(Relation relation) {
        if (relation.getProperties() == null || !relation.getProperties().isEmpty()) {
            return null;
        }
        Option date = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(relation.getProperties()).asScala()).find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ScholixUtils$.$anonfun$extractRelationDate$1(p))).map((Function1 & Serializable)p -> p.getValue());
        if (date.isDefined()) {
            return (String)date.get();
        }
        return null;
    }

    public String extractRelationDate(ScholixSummary summary) {
        if (summary.getDate() == null || summary.getDate().isEmpty()) {
            return null;
        }
        return (String)summary.getDate().get(0);
    }

    public ScholixRelationship inverseRelationShip(ScholixRelationship rel) {
        return new ScholixRelationship(rel.getInverse(), rel.getSchema(), rel.getName());
    }

    public ScholixResource generateScholixResourceFromResult(Result r) {
        ScholixSummary sum = this.resultToSummary(r);
        if (sum != null) {
            return this.generateScholixResourceFromSummary(this.resultToSummary(r));
        }
        return null;
    }

    public Aggregator<Tuple3<String, String, Object>, ScholixUtils.RelatedEntities, ScholixUtils.RelatedEntities> statsAggregator() {
        return statsAggregator;
    }

    public Aggregator<Tuple2<String, Scholix>, Scholix, Scholix> scholixAggregator() {
        return scholixAggregator;
    }

    public Scholix createInverseScholixRelation(Scholix scholix) {
        Scholix s = new Scholix();
        s.setPublicationDate(scholix.getPublicationDate());
        s.setPublisher(scholix.getPublisher());
        s.setLinkprovider(scholix.getLinkprovider());
        s.setRelationship(this.inverseRelationShip(scholix.getRelationship()));
        s.setSource(scholix.getTarget());
        s.setTarget(scholix.getSource());
        s.setIdentifier(DHPUtils.md5(s.getSource().getIdentifier() + "::" + s.getRelationship().getName() + "::" + s.getTarget().getIdentifier()));
        return s;
    }

    public String invRel(String rel) {
        ScholixUtils.RelationVocabulary semanticRelation = (ScholixUtils.RelationVocabulary)this.relations().getOrElse((Object)rel.toLowerCase(), (Function0 & Serializable)() -> null);
        if (semanticRelation != null) {
            return semanticRelation.inverse();
        }
        return null;
    }

    public List<ScholixEntityId> extractCollectedFrom(ScholixResource summary) {
        if (summary.getCollectedFrom() != null && !summary.getCollectedFrom().isEmpty()) {
            List l = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(summary.getCollectedFrom()).asScala()).map((Function1 & Serializable)d -> new ScholixEntityId(d.getProvider().getName(), d.getProvider().getIdentifiers()))).toList();
            return l;
        }
        return Nil$.MODULE$;
    }

    public List<ScholixEntityId> extractCollectedFrom(ScholixSummary summary) {
        if (summary.getDatasources() != null && !summary.getDatasources().isEmpty()) {
            List l = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(summary.getDatasources()).asScala()).map((Function1 & Serializable)d -> new ScholixEntityId(d.getDatasourceName(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ScholixIdentifier(d.getDatasourceId(), "DNET Identifier", null), (List)Nil$.MODULE$)).asJava()))).toList();
            return l;
        }
        return Nil$.MODULE$;
    }

    public List<ScholixEntityId> extractCollectedFrom(Relation relation) {
        if (relation.getCollectedfrom() != null && !relation.getCollectedfrom().isEmpty()) {
            List l = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(relation.getCollectedfrom()).asScala()).map((Function1 & Serializable)c -> new ScholixEntityId(c.getValue(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ScholixIdentifier(c.getKey(), MODULE$.DNET_IDENTIFIER_SCHEMA(), null), (List)Nil$.MODULE$)).asJava()))).toList();
            return l;
        }
        return Nil$.MODULE$;
    }

    public Scholix generateCompleteScholix(Scholix scholix, ScholixSummary target) {
        Scholix s = new Scholix();
        s.setPublicationDate(scholix.getPublicationDate());
        s.setPublisher(scholix.getPublisher());
        s.setLinkprovider(scholix.getLinkprovider());
        s.setRelationship(scholix.getRelationship());
        s.setSource(scholix.getSource());
        s.setTarget(this.generateScholixResourceFromSummary(target));
        s.setIdentifier(DHPUtils.md5(s.getSource().getIdentifier() + "::" + s.getRelationship().getName() + "::" + s.getTarget().getIdentifier()));
        return s;
    }

    public Scholix generateCompleteScholix(Scholix scholix, ScholixResource target) {
        Scholix s = new Scholix();
        s.setPublicationDate(scholix.getPublicationDate());
        s.setPublisher(scholix.getPublisher());
        s.setLinkprovider(scholix.getLinkprovider());
        s.setRelationship(scholix.getRelationship());
        s.setSource(scholix.getSource());
        s.setTarget(target);
        s.setIdentifier(DHPUtils.md5(s.getSource().getIdentifier() + "::" + s.getRelationship().getName() + "::" + s.getTarget().getIdentifier()));
        return s;
    }

    public ScholixResource generateScholixResourceFromSummary(ScholixSummary summaryObject) {
        ScholixResource r;
        block4: {
            List l;
            List plist;
            List l2;
            r = new ScholixResource();
            r.setIdentifier(summaryObject.getLocalIdentifier());
            r.setDnetIdentifier(summaryObject.getId());
            r.setObjectType(summaryObject.getTypology().toString());
            r.setObjectSubType(summaryObject.getSubType());
            if (summaryObject.getTitle() != null && !summaryObject.getTitle().isEmpty()) {
                r.setTitle((String)summaryObject.getTitle().get(0));
            }
            if (summaryObject.getAuthor() != null && !summaryObject.getAuthor().isEmpty() && (l2 = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(summaryObject.getAuthor()).asScala()).map((Function1 & Serializable)a -> new ScholixEntityId(a, null))).toList()).nonEmpty()) {
                r.setCreator((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)l2).asJava());
            }
            if (summaryObject.getDate() != null && !summaryObject.getDate().isEmpty()) {
                r.setPublicationDate((String)summaryObject.getDate().get(0));
            }
            if (summaryObject.getPublisher() != null && !summaryObject.getPublisher().isEmpty() && (plist = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(summaryObject.getPublisher()).asScala()).map((Function1 & Serializable)p -> new ScholixEntityId(p, null))).toList()).nonEmpty()) {
                r.setPublisher((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)plist).asJava());
            }
            if (summaryObject.getDatasources() == null || summaryObject.getDatasources().isEmpty() || !(l = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(summaryObject.getDatasources()).asScala()).map((Function1 & Serializable)c -> new ScholixCollectedFrom(new ScholixEntityId(c.getDatasourceName(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ScholixIdentifier(c.getDatasourceId(), MODULE$.DNET_IDENTIFIER_SCHEMA(), null), (List)Nil$.MODULE$)).asJava()), "collected", "complete"))).toList()).nonEmpty()) break block4;
            r.setCollectedFrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)l).asJava());
        }
        return r;
    }

    public Scholix scholixFromSource(Relation relation, ScholixResource source) {
        ScholixUtils.RelationVocabulary semanticRelation;
        if (relation == null || source == null) {
            return null;
        }
        Scholix s = new Scholix();
        List<ScholixEntityId> l = this.extractCollectedFrom(relation);
        if (l.isEmpty()) {
            l = this.extractCollectedFrom(source);
        }
        if (l.isEmpty()) {
            return null;
        }
        s.setLinkprovider((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(l).asJava());
        String d = this.extractRelationDate(relation);
        if (d == null) {
            d = source.getPublicationDate();
        }
        s.setPublicationDate(d);
        if (source.getPublisher() != null && !source.getPublisher().isEmpty()) {
            s.setPublisher(source.getPublisher());
        }
        if ((semanticRelation = (ScholixUtils.RelationVocabulary)this.relations().getOrElse((Object)relation.getRelClass().toLowerCase(), (Function0 & Serializable)() -> null)) == null) {
            return null;
        }
        s.setRelationship(new ScholixRelationship(semanticRelation.original(), "datacite", semanticRelation.inverse()));
        s.setSource(source);
        return s;
    }

    public Scholix scholixFromSource(Relation relation, ScholixSummary source) {
        ScholixUtils.RelationVocabulary semanticRelation;
        List l;
        if (relation == null || source == null) {
            return null;
        }
        Scholix s = new Scholix();
        List<ScholixEntityId> l2 = this.extractCollectedFrom(relation);
        if (l2.isEmpty()) {
            l2 = this.extractCollectedFrom(source);
        }
        if (l2.isEmpty()) {
            return null;
        }
        s.setLinkprovider((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(l2).asJava());
        String d = this.extractRelationDate(relation);
        if (d == null) {
            d = this.extractRelationDate(source);
        }
        s.setPublicationDate(d);
        if (source.getPublisher() != null && !source.getPublisher().isEmpty() && (l = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(source.getPublisher()).asScala()).map((Function1 & Serializable)p -> new ScholixEntityId(p, null))).toList()).nonEmpty()) {
            s.setPublisher((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)l).asJava());
        }
        if ((semanticRelation = (ScholixUtils.RelationVocabulary)this.relations().getOrElse((Object)relation.getRelClass().toLowerCase(), (Function0 & Serializable)() -> null)) == null) {
            return null;
        }
        s.setRelationship(new ScholixRelationship(semanticRelation.original(), "datacite", semanticRelation.inverse()));
        s.setSource(this.generateScholixResourceFromSummary(source));
        return s;
    }

    public List<Tuple2<StructuredProperty, String>> findURLForPID(List<StructuredProperty> pidValue, List<String> urls) {
        return pidValue.map((Function1 & Serializable)p -> {
            String pv = p.getValue();
            Option r = urls.find((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)ScholixUtils$.$anonfun$findURLForPID$2(pv, u)));
            return new Tuple2(p, r.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        });
    }

    public List<ScholixIdentifier> extractTypedIdentifierFromInstance(Result r) {
        if (r.getInstance() == null || r.getInstance().isEmpty()) {
            return Nil$.MODULE$;
        }
        return ((IterableOnceOps)((SeqOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(r.getInstance()).asScala()).filter((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)ScholixUtils$.$anonfun$extractTypedIdentifierFromInstance$1(i)))).filter((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)ScholixUtils$.$anonfun$extractTypedIdentifierFromInstance$2(i)))).flatMap((Function1 & Serializable)i -> MODULE$.findURLForPID((List<StructuredProperty>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(i.getPid()).asScala()).toList(), (List<String>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(i.getUrl()).asScala()).toList()))).map((Function1 & Serializable)i -> new ScholixIdentifier(((StructuredProperty)i._1()).getValue(), ((StructuredProperty)i._1()).getQualifier().getClassid(), (String)i._2()))).distinct()).toList();
    }

    public ScholixSummary resultToSummary(Result r) {
        List cf;
        List subjects;
        Option d;
        List dt;
        List authors;
        ScholixSummary s2 = new ScholixSummary();
        s2.setId(r.getId());
        if (r.getPid() == null || r.getPid().isEmpty()) {
            return null;
        }
        List<ScholixIdentifier> persistentIdentifiers = this.extractTypedIdentifierFromInstance(r);
        if (persistentIdentifiers.isEmpty()) {
            return null;
        }
        s2.setLocalIdentifier((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(persistentIdentifiers).asJava());
        s2.setSubType(((Instance)r.getInstance().get(0)).getInstancetype().getClassname());
        if (r.getTitle() != null && ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(r.getTitle()).asScala()).nonEmpty()) {
            List titles = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(r.getTitle()).asScala()).map((Function1 & Serializable)t -> t.getValue())).toList();
            if (titles.nonEmpty()) {
                s2.setTitle((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)titles).asJava());
            } else {
                return null;
            }
        }
        if (r.getAuthor() != null && !r.getAuthor().isEmpty() && (authors = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(r.getAuthor()).asScala()).map((Function1 & Serializable)a -> a.getFullname())).toList()).nonEmpty()) {
            s2.setAuthor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)authors).asJava());
        }
        if (r.getInstance() != null && (dt = ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(r.getInstance()).asScala()).filter((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)ScholixUtils$.$anonfun$resultToSummary$3(i)))).map((Function1 & Serializable)i -> (String)i.getDateofacceptance().getValue())).toList()).nonEmpty()) {
            s2.setDate((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)dt.distinct()).asJava());
        }
        if (r.getDescription() != null && !r.getDescription().isEmpty() && (d = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(r.getDescription()).asScala()).find((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ScholixUtils$.$anonfun$resultToSummary$5(f)))).isDefined()) {
            s2.setDescription((String)((Field)d.get()).getValue());
        }
        if (r.getSubject() != null && !r.getSubject().isEmpty() && (subjects = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(r.getSubject()).asScala()).map((Function1 & Serializable)s -> new SchemeValue(s.getQualifier().getClassname(), s.getValue()))).toList()).nonEmpty()) {
            s2.setSubject((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)subjects).asJava());
        }
        if (r.getPublisher() != null) {
            s2.setPublisher((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)((String)r.getPublisher().getValue()), (List)Nil$.MODULE$)).asJava());
        }
        if (r.getCollectedfrom() != null && !r.getCollectedfrom().isEmpty() && (cf = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(r.getCollectedfrom()).asScala()).map((Function1 & Serializable)c -> new CollectedFromType(c.getValue(), c.getKey(), "complete"))).toList()).nonEmpty()) {
            s2.setDatasources((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)cf.distinct()).asJava());
        }
        s2.setRelatedDatasets(0L);
        s2.setRelatedPublications(0L);
        s2.setRelatedUnknown(0L);
        return s2;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ScholixUtils$.class);
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$1(LazyRef formats$lzy$1) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$1;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$1.initialized() ? (DefaultFormats$)formats$lzy$1.value() : (DefaultFormats$)formats$lzy$1.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$1(LazyRef formats$lzy$1) {
        if (formats$lzy$1.initialized()) {
            return (DefaultFormats$)formats$lzy$1.value();
        }
        return ScholixUtils$.formats$lzycompute$1(formats$lzy$1);
    }

    private static final /* synthetic */ JValue json$lzycompute$1(LazyRef json$lzy$1, String input$1) {
        JValue jValue;
        LazyRef lazyRef = json$lzy$1;
        synchronized (lazyRef) {
            jValue = json$lzy$1.initialized() ? (JValue)json$lzy$1.value() : (JValue)json$lzy$1.initialize((Object)JsonMethods$.MODULE$.parse((Object)input$1, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
        }
        return jValue;
    }

    private static final JValue json$1(LazyRef json$lzy$1, String input$1) {
        if (json$lzy$1.initialized()) {
            return (JValue)json$lzy$1.value();
        }
        return ScholixUtils$.json$lzycompute$1(json$lzy$1, input$1);
    }

    public static final /* synthetic */ boolean $anonfun$extractRelationDate$1(KeyValue p) {
        return MODULE$.DATE_RELATION_KEY().equalsIgnoreCase(p.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$findURLForPID$2(String pv$1, String u) {
        return u.toLowerCase().contains(pv$1.toLowerCase());
    }

    public static final /* synthetic */ boolean $anonfun$extractTypedIdentifierFromInstance$1(Instance i) {
        return i.getUrl() != null && !i.getUrl().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$extractTypedIdentifierFromInstance$2(Instance i) {
        return i.getPid() != null && i.getUrl() != null;
    }

    public static final /* synthetic */ boolean $anonfun$resultToSummary$3(Instance i) {
        return i.getDateofacceptance() != null;
    }

    public static final /* synthetic */ boolean $anonfun$resultToSummary$5(Field f) {
        return f != null && f.getValue() != null;
    }

    private ScholixUtils$() {
    }
}

