/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.person;

import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Person;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;

public class Constants {
    public static final String ORCID_AUTHORS_CLASSID = "sysimport:crosswalk:orcid";
    public static final String ORCID_AUTHORS_CLASSNAME = "Imported from ORCID";
    public static final DataInfo ORCIDDATAINFO = OafMapperUtils.dataInfo(false, null, false, false, OafMapperUtils.qualifier("sysimport:crosswalk:orcid", "Imported from ORCID", "dnet:provenanceActions", "dnet:provenanceActions"), "0.91");
    public static final String OPENAIRE_PREFIX = "openaire____";
    public static final String SEPARATOR = "::";
    public static final String ORCID_KEY = ModelSupport.getIdPrefix(Datasource.class) + "|openaire____::" + DHPUtils.md5("orcid".toLowerCase());
    public static final String PERSON_PREFIX = ModelSupport.getIdPrefix(Person.class) + "|orcid_______";
    public static final String PROJECT_ID_PREFIX = ModelSupport.getIdPrefix(Project.class) + "|";
    public static final StructType PUBLISHER_INPUT_SCHEMA = new StructType().add("doi", DataTypes.StringType).add("authors", (DataType)DataTypes.createArrayType((DataType)new StructType().add("corresponding", DataTypes.StringType).add("contributor_roles", (DataType)DataTypes.createArrayType((DataType)new StructType().add("schema", DataTypes.StringType).add("value", DataTypes.StringType).add("name", DataTypes.StringType))).add("name", (DataType)new StructType().add("full", DataTypes.StringType).add("first", DataTypes.StringType).add("last", DataTypes.StringType)).add("matchings", (DataType)DataTypes.createArrayType((DataType)new StructType().add("PID", DataTypes.StringType).add("Value", DataTypes.StringType).add("Confidence", DataTypes.DoubleType).add("Status", DataTypes.StringType))).add("pids", (DataType)DataTypes.createArrayType((DataType)new StructType().add("schema", DataTypes.StringType).add("value", DataTypes.StringType)))));

    public static String removePrefixUrl(String pid) {
        if (pid == null) {
            return null;
        }
        String trimmed = pid.trim();
        if (trimmed.matches("(?i)^https?://(dx\\.)?doi\\.org/.*")) {
            return trimmed.replaceFirst("(?i)^https?://(dx\\.)?doi\\.org/", "");
        }
        if (trimmed.matches("(?i)^https?://orcid\\.org/.*")) {
            return trimmed.replaceFirst("(?i)^https?://orcid\\.org/", "");
        }
        return trimmed;
    }
}

