/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import eu.dnetlib.dhp.schema.mdstore.MDStoreWithInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class DHPUtils {
    private static final Logger log = LoggerFactory.getLogger(DHPUtils.class);
    public static final ObjectMapper MAPPER = new ObjectMapper();

    private DHPUtils() {
    }

    public static Seq<String> toSeq(List<String> list) {
        return ((Iterator)JavaConverters.asScalaIteratorConverter(list.iterator()).asScala()).toSeq();
    }

    public static String md5(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes(StandardCharsets.UTF_8));
            return new String(Hex.encodeHex((byte[])md.digest()));
        }
        catch (Exception e) {
            log.error("Error creating id from {}", (Object)s);
            return null;
        }
    }

    public static Set<String> mdstorePaths(String mdstoreManagerUrl, String format, String layout, String interpretation, boolean includeEmpty) throws IOException {
        String url = mdstoreManagerUrl + "/mdstores/";
        ObjectMapper objectMapper = new ObjectMapper();
        HttpGet req = new HttpGet(url);
        log.info("MDStoreManager request: {}", (Object)req);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            Set<String> set;
            block12: {
                CloseableHttpResponse response = client.execute((HttpUriRequest)req);
                try {
                    String json = IOUtils.toString((InputStream)response.getEntity().getContent());
                    log.info("MDStoreManager response: {}", (Object)json);
                    MDStoreWithInfo[] mdstores = (MDStoreWithInfo[])objectMapper.readValue(json, MDStoreWithInfo[].class);
                    set = Arrays.stream(mdstores).filter(md -> md.getFormat().equalsIgnoreCase(format)).filter(md -> md.getLayout().equalsIgnoreCase(layout)).filter(md -> md.getInterpretation().equalsIgnoreCase(interpretation)).filter(md -> StringUtils.isNotBlank((CharSequence)md.getHdfsPath())).filter(md -> StringUtils.isNotBlank((CharSequence)md.getCurrentVersion())).filter(md -> includeEmpty || md.getSize() > 0L).map(md -> md.getHdfsPath() + "/" + md.getCurrentVersion() + "/store").collect(Collectors.toSet());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return set;
        }
    }

    public static String generateIdentifier(String originalId, String nsPrefix) {
        return String.format("%s::%s", nsPrefix, DHPUtils.md5(originalId));
    }

    public static String getJPathString(String jsonPath, String json) {
        try {
            Object o = JsonPath.read((String)json, (String)jsonPath, (Predicate[])new Predicate[0]);
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof JSONArray && ((JSONArray)o).size() > 0) {
                return (String)((JSONArray)o).get(0);
            }
            return o.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void writeHdfsFile(Configuration conf, String content, String path) throws IOException {
        log.info("writing file {}, size {}", (Object)path, (Object)content.length());
        Path f = new Path(path);
        try (FileSystem fs = f.getFileSystem(conf);
             BufferedOutputStream os = new BufferedOutputStream((OutputStream)fs.create(f));){
            os.write(content.getBytes(StandardCharsets.UTF_8));
            os.flush();
        }
    }

    public static String readHdfsFile(Configuration conf, String path) throws IOException {
        log.info("reading file {}", (Object)path);
        Path p = new Path(path);
        try (FileSystem fs = p.getFileSystem(conf);){
            if (!fs.exists(p)) {
                throw new FileNotFoundException(path);
            }
            String string = IOUtils.toString((InputStream)fs.open(p));
            return string;
        }
    }

    public static <T> T readHdfsFileAs(Configuration conf, String path, Class<T> clazz) throws IOException {
        return (T)MAPPER.readValue(DHPUtils.readHdfsFile(conf, path), clazz);
    }

    public static <T> void saveDataset(Dataset<T> mdstore, String targetPath) {
        log.info("saving dataset in: {}", (Object)targetPath);
        mdstore.write().mode(SaveMode.Overwrite).format("parquet").save(targetPath);
    }

    public static Configuration getHadoopConfiguration(String nameNode) {
        Configuration hadoopConf = new Configuration();
        Properties systemProps = System.getProperties();
        for (Map.Entry<Object, Object> entry : systemProps.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!key.startsWith("spark.hadoop.")) continue;
            String hadoopKey = key.substring("spark.hadoop.".length());
            hadoopConf.set(hadoopKey, value);
        }
        if (hadoopConf.size() <= 0) {
            hadoopConf.set("fs.defaultFS", nameNode);
            hadoopConf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
            hadoopConf.set("fs.file.impl", LocalFileSystem.class.getName());
            System.setProperty("hadoop.home.dir", "/");
        }
        return hadoopConf;
    }

    public static void populateOOZIEEnv(Map<String, String> report) throws IOException {
        File file = new File(System.getProperty("oozie.action.output.properties"));
        Properties props = new Properties();
        report.forEach((k, v) -> props.setProperty((String)k, (String)v));
        try (FileOutputStream os = new FileOutputStream(file);){
            props.store(os, "");
        }
    }

    public static void populateOOZIEEnv(String paramName, String value) throws IOException {
        HashMap report = Maps.newHashMap();
        report.put(paramName, value);
        DHPUtils.populateOOZIEEnv(report);
    }
}

