/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.audit.CommonAuditContext;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.commit.CommitUtils;
import org.apache.hadoop.fs.s3a.commit.PathCommitException;
import org.apache.hadoop.fs.s3a.commit.files.PendingSet;
import org.apache.hadoop.fs.s3a.commit.files.PersistentCommitData;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.files.SuccessData;
import org.apache.hadoop.fs.s3a.commit.impl.AuditContextUpdater;
import org.apache.hadoop.fs.s3a.commit.impl.CommitContext;
import org.apache.hadoop.fs.s3a.commit.impl.CommitOperations;
import org.apache.hadoop.fs.s3a.commit.impl.CommitUtilsWithMR;
import org.apache.hadoop.fs.s3a.statistics.CommitterStatistics;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsContext;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.fs.store.audit.AuditSpanSource;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.functional.InvocationRaisingIOE;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.apache.hadoop.util.functional.TaskPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractS3AOpenAIRECommitter
extends PathOutputCommitter
implements IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractS3AOpenAIRECommitter.class);
    public static final String THREAD_PREFIX = "s3a-committer-pool-";
    @VisibleForTesting
    public static final String E_SELF_GENERATED_JOB_UUID = "has a self-generated job UUID";
    private final String uuid;
    private final JobUUIDSource uuidSource;
    protected boolean jobSetup;
    private final CommitOperations commitOperations;
    private Path outputPath;
    private final String role;
    private Path workPath;
    private Configuration conf;
    private FileSystem destFS;
    private final JobContext jobContext;
    private final boolean createJobMarker;
    private final CommitterStatistics committerStatistics;
    private final AuditSpanSource auditSpanSource;

    protected AbstractS3AOpenAIRECommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        this.setOutputPath(outputPath);
        this.jobContext = (JobContext)Objects.requireNonNull(context, "null job context");
        this.role = "Task committer " + String.valueOf(context.getTaskAttemptID());
        this.setConf(context.getConfiguration());
        Pair<String, JobUUIDSource> id = AbstractS3AOpenAIRECommitter.buildJobUUID(this.conf, context.getJobID());
        this.uuid = (String)id.getLeft();
        this.uuidSource = (JobUUIDSource)((Object)id.getRight());
        LOG.info("Job UUID {} source {}", (Object)this.getUUID(), (Object)this.getUUIDSource().getText());
        this.initOutput(outputPath);
        LOG.debug("{} instantiated for job \"{}\" ID {} with destination {}", new Object[]{this.role, CommitUtilsWithMR.jobName((JobContext)context), CommitUtilsWithMR.jobIdString((JobContext)context), outputPath});
        S3AFileSystem fs = this.getDestS3AFS();
        if (!fs.isMultipartUploadEnabled()) {
            throw new PathCommitException(outputPath, "Multipart uploads are disabled for the FileSystem, the committer can't proceed.");
        }
        new AuditContextUpdater(this.jobContext).updateCurrentAuditContext();
        this.auditSpanSource = fs.getAuditSpanSource();
        this.createJobMarker = context.getConfiguration().getBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", true);
        this.committerStatistics = fs.newCommitterStatistics();
        this.commitOperations = new CommitOperations(fs, this.committerStatistics, outputPath.toString());
    }

    @VisibleForTesting
    protected void initOutput(Path out) throws IOException {
        FileSystem fs = this.getDestinationFS(out, this.getConf());
        this.setDestFS(fs);
        this.setOutputPath(fs.makeQualified(out));
    }

    public final JobContext getJobContext() {
        return this.jobContext;
    }

    public final Path getOutputPath() {
        return this.outputPath;
    }

    protected final void setOutputPath(Path outputPath) {
        this.outputPath = Objects.requireNonNull(outputPath, "Null output path");
    }

    public final Path getWorkPath() {
        return this.workPath;
    }

    protected final void setWorkPath(Path workPath) {
        LOG.debug("Setting work path to {}", (Object)workPath);
        this.workPath = workPath;
    }

    public final Configuration getConf() {
        return this.conf;
    }

    protected final void setConf(Configuration conf) {
        this.conf = conf;
    }

    public FileSystem getDestFS() throws IOException {
        if (this.destFS == null) {
            FileSystem fs = this.getDestinationFS(this.outputPath, this.getConf());
            this.setDestFS(fs);
        }
        return this.destFS;
    }

    public S3AFileSystem getDestS3AFS() throws IOException {
        return (S3AFileSystem)this.getDestFS();
    }

    protected void setDestFS(FileSystem destFS) {
        this.destFS = destFS;
    }

    public Path getJobAttemptPath(JobContext context) {
        return this.getJobAttemptPath(CommitUtilsWithMR.getAppAttemptId((JobContext)context));
    }

    protected abstract Path getJobPath();

    protected abstract Path getJobAttemptPath(int var1);

    public Path getTaskAttemptPath(TaskAttemptContext context) {
        return this.getBaseTaskAttemptPath(context);
    }

    protected abstract Path getBaseTaskAttemptPath(TaskAttemptContext var1);

    public abstract Path getTempTaskAttemptPath(TaskAttemptContext var1);

    public abstract String getName();

    @VisibleForTesting
    public final String getUUID() {
        return this.uuid;
    }

    @VisibleForTesting
    public final JobUUIDSource getUUIDSource() {
        return this.uuidSource;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractS3ACommitter{");
        sb.append("role=").append(this.role);
        sb.append(", name=").append(this.getName());
        sb.append(", outputPath=").append(this.getOutputPath());
        sb.append(", workPath=").append(this.workPath);
        sb.append(", uuid='").append(this.getUUID()).append('\'');
        sb.append(", uuid source=").append((Object)this.getUUIDSource());
        sb.append('}');
        return sb.toString();
    }

    protected FileSystem getDestinationFS(Path out, Configuration config) throws IOException {
        return CommitUtils.getS3AFileSystem((Path)out, (Configuration)config, (boolean)this.requiresDelayedCommitOutputInFileSystem());
    }

    protected boolean requiresDelayedCommitOutputInFileSystem() {
        return false;
    }

    public void recoverTask(TaskAttemptContext taskContext) throws IOException {
        LOG.warn("Cannot recover task {}", (Object)taskContext.getTaskAttemptID());
        throw new PathCommitException(this.outputPath, String.format("Unable to recover task %s", taskContext.getTaskAttemptID()));
    }

    protected SuccessData maybeCreateSuccessMarkerFromCommits(CommitContext commitContext, ActiveCommit pending) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>(pending.size());
        filenames.addAll(pending.committedObjects);
        IOStatisticsSnapshot snapshot = new IOStatisticsSnapshot((IOStatistics)pending.getIOStatistics());
        snapshot.aggregate(this.getIOStatistics());
        if (commitContext.isCollectIOStatistics()) {
            snapshot.aggregate(commitContext.getIOStatisticsContext().getIOStatistics());
        }
        return this.maybeCreateSuccessMarker(commitContext.getJobContext(), filenames, snapshot);
    }

    protected SuccessData maybeCreateSuccessMarker(JobContext context, List<String> filenames, IOStatisticsSnapshot ioStatistics) throws IOException {
        SuccessData successData = this.createSuccessData(context, filenames, ioStatistics, this.getDestFS().getConf());
        if (this.createJobMarker) {
            this.commitOperations.createSuccessMarker(this.getOutputPath(), successData, true);
        }
        return successData;
    }

    private SuccessData createSuccessData(JobContext context, List<String> filenames, IOStatisticsSnapshot ioStatistics, Configuration destConf) {
        SuccessData successData = new SuccessData();
        successData.setCommitter(this.getName());
        successData.setJobId(this.uuid);
        successData.setJobIdSource(this.uuidSource.getText());
        successData.setDescription(this.getRole());
        successData.setHostname(NetUtils.getLocalHostname());
        Date now = new Date();
        successData.setTimestamp(now.getTime());
        successData.setDate(now.toString());
        if (filenames != null) {
            successData.setFilenames(filenames);
        }
        successData.getIOStatistics().aggregate((IOStatistics)ioStatistics);
        successData.addDiagnostic("fs.s3a.committer.threads", Integer.toString(this.getJobCommitThreadCount(context)));
        if (destConf != null) {
            successData.addDiagnostic("fs.s3a.connection.maximum", destConf.get("fs.s3a.connection.maximum", Integer.toString(500)));
            successData.addDiagnostic("fs.s3a.max.total.tasks", destConf.get("fs.s3a.max.total.tasks", Integer.toString(32)));
        }
        return successData;
    }

    public void setupJob(JobContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Job %s setting up", new Object[]{this.getUUID()});){
            this.jobSetup = true;
            Configuration c = context.getConfiguration();
            c.set("fs.s3a.committer.uuid", this.getUUID());
            c.set("fs.s3a.committer.uuid.source", this.getUUIDSource().getText());
            Path dest = this.getOutputPath();
            if (this.createJobMarker) {
                this.commitOperations.deleteSuccessMarker(dest);
            }
            this.getDestFS().mkdirs(dest);
            this.warnOnActiveUploads(dest);
        }
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        TaskAttemptID attemptID = context.getTaskAttemptID();
        new AuditContextUpdater((JobContext)context).updateCurrentAuditContext();
        try (DurationInfo d = new DurationInfo(LOG, "Setup Task %s", new Object[]{attemptID});){
            if (!this.jobSetup && this.getUUIDSource() == JobUUIDSource.GeneratedLocally) {
                throw new PathCommitException(this.getOutputPath().toString(), "Task attempt " + String.valueOf(attemptID) + " has a self-generated job UUID");
            }
            Path taskAttemptPath = this.getTaskAttemptPath(context);
            FileSystem fs = taskAttemptPath.getFileSystem(this.getConf());
            fs.delete(taskAttemptPath, true);
            fs.mkdirs(taskAttemptPath);
        }
    }

    protected FileSystem getTaskAttemptFilesystem(TaskAttemptContext context) throws IOException {
        return this.getTaskAttemptPath(context).getFileSystem(this.getConf());
    }

    protected void commitPendingUploads(CommitContext commitContext, ActiveCommit pending) throws IOException {
        if (pending.isEmpty()) {
            LOG.warn("{}: No pending uploads to commit", (Object)this.getRole());
        }
        try (DurationInfo ignored = new DurationInfo(LOG, "committing the output of %s task(s)", new Object[]{pending.size()});){
            TaskPool.foreach(pending.getSourceFiles()).stopOnFailure().suppressExceptions(false).executeWith(commitContext.getOuterSubmitter()).abortWith(status -> this.loadAndAbort(commitContext, pending, (FileStatus)status, true, false)).revertWith(status -> this.loadAndRevert(commitContext, pending, (FileStatus)status)).run(status -> this.loadAndCommit(commitContext, pending, (FileStatus)status));
        }
    }

    protected void precommitCheckPendingFiles(CommitContext commitContext, ActiveCommit pending) throws IOException {
        FileSystem sourceFS = pending.getSourceFS();
        try (DurationInfo ignored = new DurationInfo(LOG, "Preflight Load of pending files", new Object[0]);){
            TaskPool.foreach(pending.getSourceFiles()).stopOnFailure().suppressExceptions(false).executeWith(commitContext.getOuterSubmitter()).run(status -> PersistentCommitData.load((FileSystem)sourceFS, (FileStatus)status, (JsonSerialization)commitContext.getPendingSetSerializer()));
        }
    }

    private void loadAndCommit(CommitContext commitContext, ActiveCommit activeCommit, FileStatus status) throws IOException {
        Path path = status.getPath();
        commitContext.switchToIOStatisticsContext();
        try (DurationInfo ignored = new DurationInfo(LOG, "Loading and committing files in pendingset %s", new Object[]{path});){
            PendingSet pendingSet = (PendingSet)PersistentCommitData.load((FileSystem)activeCommit.getSourceFS(), (FileStatus)status, (JsonSerialization)commitContext.getPendingSetSerializer());
            String jobId = pendingSet.getJobId();
            if (!StringUtils.isEmpty((CharSequence)jobId) && !this.getUUID().equals(jobId)) {
                throw new PathCommitException(path, String.format("Mismatch in Job ID (%s) and commit job ID (%s)", this.getUUID(), jobId));
            }
            TaskPool.foreach((Iterable)pendingSet.getCommits()).stopOnFailure().suppressExceptions(false).executeWith(commitContext.getInnerSubmitter()).onFailure((commit, exception) -> commitContext.abortSingleCommit(commit)).abortWith(arg_0 -> ((CommitContext)commitContext).abortSingleCommit(arg_0)).revertWith(arg_0 -> ((CommitContext)commitContext).revertCommit(arg_0)).run(commit -> {
                commitContext.commitOrFail(commit);
                activeCommit.uploadCommitted(commit.getDestinationKey(), commit.getLength());
            });
            activeCommit.pendingsetCommitted((IOStatistics)pendingSet.getIOStatistics());
        }
    }

    private void loadAndRevert(CommitContext commitContext, ActiveCommit activeCommit, FileStatus status) throws IOException {
        Path path = status.getPath();
        commitContext.switchToIOStatisticsContext();
        try (DurationInfo ignored = new DurationInfo(LOG, false, "Committing %s", new Object[]{path});){
            PendingSet pendingSet = (PendingSet)PersistentCommitData.load((FileSystem)activeCommit.getSourceFS(), (FileStatus)status, (JsonSerialization)commitContext.getPendingSetSerializer());
            TaskPool.foreach((Iterable)pendingSet.getCommits()).suppressExceptions(true).run(arg_0 -> ((CommitContext)commitContext).revertCommit(arg_0));
        }
    }

    private void loadAndAbort(CommitContext commitContext, ActiveCommit activeCommit, FileStatus status, boolean suppressExceptions, boolean deleteRemoteFiles) throws IOException {
        Path path = status.getPath();
        commitContext.switchToIOStatisticsContext();
        try (DurationInfo ignored = new DurationInfo(LOG, false, "Aborting %s", new Object[]{path});){
            PendingSet pendingSet = (PendingSet)PersistentCommitData.load((FileSystem)activeCommit.getSourceFS(), (FileStatus)status, (JsonSerialization)commitContext.getPendingSetSerializer());
            FileSystem fs = this.getDestFS();
            TaskPool.foreach((Iterable)pendingSet.getCommits()).executeWith(commitContext.getInnerSubmitter()).suppressExceptions(suppressExceptions).run(commit -> {
                block2: {
                    try {
                        commitContext.abortSingleCommit(commit);
                    }
                    catch (FileNotFoundException e) {
                        if (!deleteRemoteFiles) break block2;
                        fs.delete(commit.destinationPath(), false);
                    }
                }
            });
        }
    }

    protected CommitContext initiateJobOperation(JobContext context) throws IOException {
        IOStatisticsContext ioStatisticsContext = IOStatisticsContext.getCurrentIOStatisticsContext();
        CommitContext commitContext = this.getCommitOperations().createCommitContext(context, this.getOutputPath(), this.getJobCommitThreadCount(context), ioStatisticsContext);
        commitContext.maybeResetIOStatisticsContext();
        return commitContext;
    }

    protected CommitContext initiateTaskOperation(JobContext context) throws IOException {
        CommitContext commitContext = this.getCommitOperations().createCommitContext(context, this.getOutputPath(), this.getTaskCommitThreadCount(context), IOStatisticsContext.getCurrentIOStatisticsContext());
        commitContext.maybeResetIOStatisticsContext();
        return commitContext;
    }

    protected void commitJobInternal(CommitContext commitContext, ActiveCommit pending) throws IOException {
        IOStatisticsBinding.trackDurationOfInvocation((DurationTrackerFactory)this.committerStatistics, (String)Statistic.COMMITTER_COMMIT_JOB.getSymbol(), () -> this.commitPendingUploads(commitContext, pending));
    }

    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        LOG.info("{}: aborting job {} in state {}", new Object[]{this.getRole(), CommitUtilsWithMR.jobIdString((JobContext)context), state});
        try (CommitContext commitContext = this.initiateJobOperation(context);){
            this.abortJobInternal(commitContext, false);
        }
    }

    protected void abortJobInternal(CommitContext commitContext, boolean suppressExceptions) throws IOException {
        this.cleanup(commitContext, suppressExceptions);
    }

    protected void abortPendingUploadsInCleanup(boolean suppressExceptions, CommitContext commitContext) throws IOException {
        if (!this.shouldAbortUploadsInCleanup()) {
            LOG.debug("Not cleanup up pending uploads to {} as {} is false ", (Object)this.getOutputPath(), (Object)"fs.s3a.committer.abort.pending.uploads");
            return;
        }
        Path dest = this.getOutputPath();
        DurationInfo ignored = new DurationInfo(LOG, "Aborting all pending commits under %s", new Object[]{dest});
        try {
            List pending;
            CommitOperations ops = this.getCommitOperations();
            try {
                pending = ops.listPendingUploadsUnderPath(dest);
            }
            catch (IOException e) {
                LOG.debug("Failed to list pending uploads under {}", (Object)dest, (Object)e);
                ignored.close();
                return;
            }
            if (!pending.isEmpty()) {
                LOG.warn("{} pending uploads were found -aborting", (Object)pending.size());
                LOG.warn("If other tasks/jobs are writing to {},this action may cause them to fail", (Object)dest);
                TaskPool.foreach((Iterable)pending).executeWith(commitContext.getOuterSubmitter()).suppressExceptions(suppressExceptions).run(u -> commitContext.abortMultipartCommit(u.key(), u.uploadId()));
            } else {
                LOG.info("No pending uploads were found");
            }
        }
        finally {
            try {
                ignored.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    private boolean shouldAbortUploadsInCleanup() {
        return this.getConf().getBoolean("fs.s3a.committer.abort.pending.uploads", false);
    }

    @VisibleForTesting
    public void preCommitJob(CommitContext commitContext, ActiveCommit pending) throws IOException {
    }

    public void commitJob(JobContext context) throws IOException {
        block12: {
            String stage;
            IOException failure;
            SuccessData successData;
            CommitContext commitContext;
            block13: {
                String id = CommitUtilsWithMR.jobIdString((JobContext)context);
                commitContext = null;
                successData = null;
                failure = null;
                stage = "preparing";
                try {
                    try (DurationInfo d = new DurationInfo(LOG, "%s: commitJob(%s)", new Object[]{this.getRole(), id});){
                        commitContext = this.initiateJobOperation(context);
                        ActiveCommit pending = this.listPendingUploadsToCommit(commitContext);
                        stage = "precommit";
                        this.preCommitJob(commitContext, pending);
                        stage = "commit";
                        this.commitJobInternal(commitContext, pending);
                        stage = "completed";
                        this.jobCompleted(true);
                        stage = "marker";
                        successData = this.maybeCreateSuccessMarkerFromCommits(commitContext, pending);
                        stage = "cleanup";
                        this.cleanup(commitContext, false);
                    }
                    if (commitContext == null) break block12;
                    if (successData != null) break block13;
                    successData = this.createSuccessData(context, null, null, this.getDestFS().getConf());
                }
                catch (IOException e) {
                    try {
                        failure = e;
                        LOG.warn("Commit failure for job {}", (Object)id, (Object)e);
                        this.jobCompleted(false);
                        this.abortJobInternal(commitContext, true);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (commitContext != null) {
                            if (successData == null) {
                                successData = this.createSuccessData(context, null, null, this.getDestFS().getConf());
                            }
                            AbstractS3AOpenAIRECommitter.maybeSaveSummary(stage, commitContext, successData, failure, true, true);
                            commitContext.close();
                        }
                        throw throwable;
                    }
                }
            }
            AbstractS3AOpenAIRECommitter.maybeSaveSummary(stage, commitContext, successData, failure, true, true);
            commitContext.close();
        }
    }

    protected void jobCompleted(boolean success) {
        this.getCommitOperations().jobCompleted(success);
    }

    public abstract void cleanupStagingDirs();

    protected abstract ActiveCommit listPendingUploadsToCommit(CommitContext var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup(CommitContext commitContext, boolean suppressExceptions) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Cleanup job %s", new Object[]{CommitUtilsWithMR.jobIdString((JobContext)commitContext.getJobContext())});){
            this.abortPendingUploadsInCleanup(suppressExceptions, commitContext);
        }
        finally {
            this.cleanupStagingDirs();
        }
    }

    public void cleanupJob(JobContext context) throws IOException {
        String r = this.getRole();
        String id = CommitUtilsWithMR.jobIdString((JobContext)context);
        LOG.warn("{}: using deprecated cleanupJob call for {}", (Object)r, (Object)id);
        try (DurationInfo d = new DurationInfo(LOG, "%s: cleanup Job %s", new Object[]{r, id});
             CommitContext commitContext = this.initiateJobOperation(context);){
            this.cleanup(commitContext, true);
        }
    }

    protected void maybeIgnore(boolean suppress, String action, InvocationRaisingIOE operation) throws IOException {
        if (suppress) {
            Invoker.ignoreIOExceptions((Logger)LOG, (String)action, (String)"", (InvocationRaisingIOE)operation);
        } else {
            operation.apply();
        }
    }

    protected void maybeIgnore(boolean suppress, String action, IOException ex) throws IOException {
        if (!suppress) {
            throw ex;
        }
        LOG.debug(action, (Throwable)ex);
    }

    protected CommitOperations getCommitOperations() {
        return this.commitOperations;
    }

    protected String getRole() {
        return this.role;
    }

    private int getJobCommitThreadCount(JobContext context) {
        return context.getConfiguration().getInt("fs.s3a.committer.threads", 32);
    }

    private int getTaskCommitThreadCount(JobContext context) {
        return context.getConfiguration().getInt("fs.s3a.committer.threads", 32);
    }

    protected void deleteTaskAttemptPathQuietly(TaskAttemptContext context) {
        Path attemptPath = this.getBaseTaskAttemptPath(context);
        Invoker.ignoreIOExceptions((Logger)LOG, (String)"Delete task attempt path", (String)attemptPath.toString(), () -> S3AUtils.deleteQuietly((FileSystem)this.getTaskAttemptFilesystem(context), (Path)attemptPath, (boolean)true));
    }

    protected void abortPendingUploads(CommitContext commitContext, List<SinglePendingCommit> pending, boolean suppressExceptions) throws IOException {
        if (pending == null || pending.isEmpty()) {
            LOG.info("{}: no pending commits to abort", (Object)this.getRole());
        } else {
            try (DurationInfo d = new DurationInfo(LOG, "Aborting %s uploads", new Object[]{pending.size()});){
                TaskPool.foreach(pending).executeWith(commitContext.getOuterSubmitter()).suppressExceptions(suppressExceptions).run(arg_0 -> ((CommitContext)commitContext).abortSingleCommit(arg_0));
            }
        }
    }

    protected void abortPendingUploads(CommitContext commitContext, ActiveCommit pending, boolean suppressExceptions, boolean deleteRemoteFiles) throws IOException {
        if (pending.isEmpty()) {
            LOG.info("{}: no pending commits to abort", (Object)this.getRole());
        } else {
            try (DurationInfo d = new DurationInfo(LOG, "Aborting %s uploads", new Object[]{pending.size()});){
                TaskPool.foreach(pending.getSourceFiles()).executeWith(commitContext.getOuterSubmitter()).suppressExceptions(suppressExceptions).run(path -> this.loadAndAbort(commitContext, pending, (FileStatus)path, suppressExceptions, deleteRemoteFiles));
            }
        }
    }

    public IOStatistics getIOStatistics() {
        return this.committerStatistics.getIOStatistics();
    }

    protected void warnOnActiveUploads(Path path) {
        List pending;
        try {
            pending = this.getCommitOperations().listPendingUploadsUnderPath(path);
        }
        catch (IOException e) {
            LOG.debug("Failed to list uploads under {}", (Object)path, (Object)e);
            return;
        }
        if (!pending.isEmpty()) {
            LOG.warn("{} active upload(s) in progress under {}", (Object)pending.size(), (Object)path);
            LOG.warn("Either jobs are running concurrently or failed jobs are not being cleaned up");
            DateFormat df = DateFormat.getDateTimeInstance();
            pending.forEach(u -> LOG.info("[{}] {}", (Object)df.format(Date.from(u.initiated())), (Object)u.key()));
            if (this.shouldAbortUploadsInCleanup()) {
                LOG.warn("This committer will abort these uploads in job cleanup");
            }
        }
    }

    public static Pair<String, JobUUIDSource> buildJobUUID(Configuration conf, JobID jobId) throws PathCommitException {
        String jobUUID = conf.getTrimmed("fs.s3a.committer.uuid", "");
        if (!jobUUID.isEmpty()) {
            return Pair.of((Object)jobUUID, (Object)((Object)JobUUIDSource.CommitterUUIDProperty));
        }
        jobUUID = conf.getTrimmed("spark.sql.sources.writeJobUUID", "");
        if (!jobUUID.isEmpty()) {
            return Pair.of((Object)jobUUID, (Object)((Object)JobUUIDSource.SparkWriteUUID));
        }
        if (conf.getBoolean("fs.s3a.committer.require.uuid", false)) {
            throw new PathCommitException("", "Job/task context does not contain a unique ID in spark.sql.sources.writeJobUUID");
        }
        if (conf.getBoolean("fs.s3a.committer.generate.uuid", false)) {
            String newId = UUID.randomUUID().toString();
            LOG.warn("No job ID in configuration; generating a random ID: {}", (Object)newId);
            return Pair.of((Object)newId, (Object)((Object)JobUUIDSource.GeneratedLocally));
        }
        return Pair.of((Object)jobId.toString(), (Object)((Object)JobUUIDSource.JobID));
    }

    protected final void updateCommonContext() {
        CommonAuditContext.currentAuditContext().put("ji", this.uuid);
    }

    protected AuditSpanSource getAuditSpanSource() {
        return this.auditSpanSource;
    }

    protected AuditSpan startOperation(String name, @Nullable String path1, @Nullable String path2) throws IOException {
        return this.getAuditSpanSource().createSpan(name, path1, path2);
    }

    /*
     * Exception decompiling
     */
    private static Path maybeSaveSummary(String activeStage, CommitContext context, SuccessData report, Throwable thrown, boolean quiet, boolean overwrite) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 7[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static enum JobUUIDSource {
        SparkWriteUUID("spark.sql.sources.writeJobUUID"),
        CommitterUUIDProperty("fs.s3a.committer.uuid"),
        JobID("JobID"),
        GeneratedLocally("Generated Locally");

        private final String text;

        private JobUUIDSource(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("JobUUIDSource{");
            sb.append("text='").append(this.text).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static final class ActiveCommit {
        private static final ActiveCommit EMPTY = new ActiveCommit(null, new ArrayList());
        private final List<FileStatus> sourceFiles;
        private final FileSystem sourceFS;
        private final List<String> committedObjects = new ArrayList<String>();
        private int committedObjectCount;
        private long committedBytes;
        private final IOStatisticsSnapshot ioStatistics = new IOStatisticsSnapshot();

        public ActiveCommit(FileSystem sourceFS, List<? extends FileStatus> sourceFiles) {
            this.sourceFiles = sourceFiles;
            this.sourceFS = sourceFS;
        }

        public static ActiveCommit fromStatusIterator(FileSystem pendingFS, RemoteIterator<? extends FileStatus> statuses) throws IOException {
            return new ActiveCommit(pendingFS, RemoteIterators.toList(statuses));
        }

        public static ActiveCommit empty() {
            return EMPTY;
        }

        public List<FileStatus> getSourceFiles() {
            return this.sourceFiles;
        }

        public FileSystem getSourceFS() {
            return this.sourceFS;
        }

        public synchronized void uploadCommitted(String key, long size) {
            if (this.committedObjects.size() < 100) {
                this.committedObjects.add((String)(key.startsWith("/") ? key : "/" + key));
            }
            ++this.committedObjectCount;
            this.committedBytes += size;
        }

        public void pendingsetCommitted(IOStatistics sourceStatistics) {
            this.ioStatistics.aggregate(sourceStatistics);
        }

        public IOStatisticsSnapshot getIOStatistics() {
            return this.ioStatistics;
        }

        public synchronized List<String> getCommittedObjects() {
            return this.committedObjects;
        }

        public synchronized int getCommittedFileCount() {
            return this.committedObjectCount;
        }

        public synchronized long getCommittedBytes() {
            return this.committedBytes;
        }

        public int size() {
            return this.sourceFiles.size();
        }

        public boolean isEmpty() {
            return this.sourceFiles.isEmpty();
        }

        public void add(FileStatus status) {
            this.sourceFiles.add(status);
        }
    }
}

