/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common;

import eu.dnetlib.dhp.common.ThrowingSupport;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsSupport {
    private static final Logger logger = LoggerFactory.getLogger(HdfsSupport.class);

    private HdfsSupport() {
    }

    public static boolean exists(String path, Configuration configuration) {
        logger.info("Checking existence for path: {}", (Object)path);
        return ThrowingSupport.rethrowAsRuntimeException(() -> {
            Path f = new Path(path);
            FileSystem fileSystem = f.getFileSystem(configuration);
            if (path.contains("*")) {
                FileStatus[] fileStatus = fileSystem.globStatus(f);
                if (fileStatus != null) {
                    Arrays.stream(fileStatus).forEach(fs -> logger.info("Glob path: {}", (Object)fs.getPath()));
                }
                logger.info("Glob path exists: {}", (Object)(fileStatus != null && fileStatus.length > 0 ? 1 : 0));
                return fileStatus != null && fileStatus.length > 0;
            }
            return fileSystem.exists(f);
        });
    }

    public static void remove(String path, Configuration configuration) {
        logger.info("Removing path: {}", (Object)path);
        ThrowingSupport.rethrowAsRuntimeException(() -> {
            Path f = new Path(path);
            FileSystem fileSystem = f.getFileSystem(configuration);
            if (fileSystem.exists(f)) {
                fileSystem.delete(f, true);
            }
        });
    }

    public static List<String> listFiles(String path, Configuration configuration) {
        logger.info("Listing files in path: {}", (Object)path);
        Path f = new Path(path);
        return ThrowingSupport.rethrowAsRuntimeException(() -> Arrays.stream(f.getFileSystem(configuration).listStatus(f)).filter(FileStatus::isDirectory).map(x -> x.getPath().toString()).collect(Collectors.toList()));
    }
}

