/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf.utils;

import eu.dnetlib.dhp.schema.common.AccessRightComparator;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.ExtraInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Measure;
import eu.dnetlib.dhp.schema.oaf.OAIProvenance;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OpenAccessRoute;
import eu.dnetlib.dhp.schema.oaf.OriginDescription;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Subject;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OafMapperUtils {
    private OafMapperUtils() {
    }

    public static KeyValue keyValue(String k, String v) {
        KeyValue kv = new KeyValue();
        kv.setKey(k);
        kv.setValue(v);
        return kv;
    }

    public static List<KeyValue> listKeyValues(String ... s) {
        if (s.length % 2 > 0) {
            throw new IllegalArgumentException("Invalid number of parameters (k,v,k,v,....)");
        }
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        for (int i = 0; i < s.length; i += 2) {
            list.add(OafMapperUtils.keyValue(s[i], s[i + 1]));
        }
        return list;
    }

    public static <T> Field<T> field(T value, DataInfo info) {
        if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        Field field = new Field();
        field.setValue(value);
        field.setDataInfo(info);
        return field;
    }

    public static List<Field<String>> listFields(DataInfo info, String ... values) {
        return Arrays.stream(values).map(v -> OafMapperUtils.field(v, info)).filter(Objects::nonNull).filter(OafMapperUtils.distinctByKey(Field::getValue)).collect(Collectors.toList());
    }

    public static <T> List<T> listValues(Array values) throws SQLException {
        if (Objects.isNull(values)) {
            return null;
        }
        return Arrays.stream((Object[])values.getArray()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static List<Field<String>> listFields(DataInfo info, List<String> values) {
        return values.stream().map(v -> OafMapperUtils.field(v, info)).filter(Objects::nonNull).filter(OafMapperUtils.distinctByKey(Field::getValue)).collect(Collectors.toList());
    }

    public static InstanceTypeMapping instanceTypeMapping(String originalType, String code, String label, String vocabularyName) {
        InstanceTypeMapping m = new InstanceTypeMapping();
        m.setVocabularyName(vocabularyName);
        m.setOriginalType(originalType);
        m.setTypeCode(code);
        m.setTypeLabel(label);
        return m;
    }

    public static InstanceTypeMapping instanceTypeMapping(String originalType, Qualifier term) {
        return OafMapperUtils.instanceTypeMapping(originalType, term.getClassid(), term.getClassname(), term.getSchemeid());
    }

    public static InstanceTypeMapping instanceTypeMapping(String originalType) {
        return OafMapperUtils.instanceTypeMapping(originalType, null, null, null);
    }

    public static InstanceTypeMapping instanceTypeMapping(String originalType, String vocabularyName) {
        return OafMapperUtils.instanceTypeMapping(originalType, null, null, vocabularyName);
    }

    public static Qualifier unknown(String schemeid, String schemename) {
        return OafMapperUtils.qualifier("UNKNOWN", "Unknown", schemeid, schemename);
    }

    public static AccessRight accessRight(String classid, String classname, String schemeid, String schemename) {
        return OafMapperUtils.accessRight(classid, classname, schemeid, schemename, null);
    }

    public static AccessRight accessRight(String classid, String classname, String schemeid, String schemename, OpenAccessRoute openAccessRoute) {
        AccessRight accessRight = new AccessRight();
        accessRight.setClassid(classid);
        accessRight.setClassname(classname);
        accessRight.setSchemeid(schemeid);
        accessRight.setSchemename(schemename);
        accessRight.setOpenAccessRoute(openAccessRoute);
        return accessRight;
    }

    public static Qualifier qualifier(String classid, String classname, String schemeid, String schemename) {
        Qualifier q = new Qualifier();
        q.setClassid(classid);
        q.setClassname(classname);
        q.setSchemeid(schemeid);
        q.setSchemename(schemename);
        return q;
    }

    public static Qualifier qualifier(Qualifier qualifier) {
        Qualifier q = new Qualifier();
        q.setClassid(qualifier.getClassid());
        q.setClassname(qualifier.getClassname());
        q.setSchemeid(qualifier.getSchemeid());
        q.setSchemename(qualifier.getSchemename());
        return q;
    }

    public static Subject subject(String value, String classid, String classname, String schemeid, String schemename, DataInfo dataInfo) {
        return OafMapperUtils.subject(value, OafMapperUtils.qualifier(classid, classname, schemeid, schemename), dataInfo);
    }

    public static StructuredProperty structuredProperty(String value, String classid, String classname, String schemeid, String schemename, DataInfo dataInfo) {
        return OafMapperUtils.structuredProperty(value, OafMapperUtils.qualifier(classid, classname, schemeid, schemename), dataInfo);
    }

    public static Subject subject(String value, Qualifier qualifier, DataInfo dataInfo) {
        if (value == null) {
            return null;
        }
        Subject s = new Subject();
        s.setValue(value);
        s.setQualifier(qualifier);
        s.setDataInfo(dataInfo);
        return s;
    }

    public static StructuredProperty structuredProperty(String value, Qualifier qualifier, DataInfo dataInfo) {
        if (value == null) {
            return null;
        }
        StructuredProperty sp = new StructuredProperty();
        sp.setValue(value);
        sp.setQualifier(qualifier);
        sp.setDataInfo(dataInfo);
        return sp;
    }

    public static ExtraInfo extraInfo(String name, String value, String typology, String provenance, String trust) {
        ExtraInfo info = new ExtraInfo();
        info.setName(name);
        info.setValue(value);
        info.setTypology(typology);
        info.setProvenance(provenance);
        info.setTrust(trust);
        return info;
    }

    public static OAIProvenance oaiIProvenance(String identifier, String baseURL, String metadataNamespace, Boolean altered, String datestamp, String harvestDate) {
        OriginDescription desc = new OriginDescription();
        desc.setIdentifier(identifier);
        desc.setBaseURL(baseURL);
        desc.setMetadataNamespace(metadataNamespace);
        desc.setAltered(altered);
        desc.setDatestamp(datestamp);
        desc.setHarvestDate(harvestDate);
        OAIProvenance p = new OAIProvenance();
        p.setOriginDescription(desc);
        return p;
    }

    public static Journal journal(String name, String issnPrinted, String issnOnline, String issnLinking, DataInfo dataInfo) {
        return OafMapperUtils.hasIssn(issnPrinted, issnOnline, issnLinking) ? OafMapperUtils.journal(name, issnPrinted, issnOnline, issnLinking, null, null, null, null, null, null, null, dataInfo) : null;
    }

    public static Journal journal(String name, String issnPrinted, String issnOnline, String issnLinking, String ep, String iss, String sp, String vol, String edition, String conferenceplace, String conferencedate, DataInfo dataInfo) {
        if (StringUtils.isNotBlank((CharSequence)name) || OafMapperUtils.hasIssn(issnPrinted, issnOnline, issnLinking)) {
            Journal j = new Journal();
            j.setName(name);
            j.setIssnPrinted(issnPrinted);
            j.setIssnOnline(issnOnline);
            j.setIssnLinking(issnLinking);
            j.setEp(ep);
            j.setIss(iss);
            j.setSp(sp);
            j.setVol(vol);
            j.setEdition(edition);
            j.setConferenceplace(conferenceplace);
            j.setConferencedate(conferencedate);
            j.setDataInfo(dataInfo);
            return j;
        }
        return null;
    }

    private static boolean hasIssn(String issnPrinted, String issnOnline, String issnLinking) {
        return StringUtils.isNotBlank((CharSequence)issnPrinted) || StringUtils.isNotBlank((CharSequence)issnOnline) || StringUtils.isNotBlank((CharSequence)issnLinking);
    }

    public static DataInfo dataInfo(Boolean deletedbyinference, String inferenceprovenance, Boolean inferred, Boolean invisible, Qualifier provenanceaction, String trust) {
        DataInfo d = new DataInfo();
        d.setDeletedbyinference(deletedbyinference);
        d.setInferenceprovenance(inferenceprovenance);
        d.setInferred(inferred);
        d.setInvisible(invisible);
        d.setProvenanceaction(provenanceaction);
        d.setTrust(trust);
        return d;
    }

    public static String createOpenaireId(int prefix, String originalId, boolean to_md5) {
        if (StringUtils.isBlank((CharSequence)originalId)) {
            return null;
        }
        if (to_md5) {
            String nsPrefix = StringUtils.substringBefore((String)originalId, (String)"::");
            String rest = StringUtils.substringAfter((String)originalId, (String)"::");
            return String.format("%s|%s::%s", prefix, nsPrefix, IdentifierFactory.md5(rest));
        }
        return String.format("%s|%s", prefix, originalId);
    }

    public static String createOpenaireId(String type, String originalId, boolean to_md5) {
        switch (type) {
            case "datasource": {
                return OafMapperUtils.createOpenaireId(10, originalId, to_md5);
            }
            case "organization": {
                return OafMapperUtils.createOpenaireId(20, originalId, to_md5);
            }
            case "person": {
                return OafMapperUtils.createOpenaireId(30, originalId, to_md5);
            }
            case "project": {
                return OafMapperUtils.createOpenaireId(40, originalId, to_md5);
            }
        }
        return OafMapperUtils.createOpenaireId(50, originalId, to_md5);
    }

    public static String asString(Object o) {
        return o == null ? "" : o.toString();
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static Qualifier createBestAccessRights(List<Instance> instanceList) {
        return OafMapperUtils.getBestAccessRights(instanceList);
    }

    protected static Qualifier getBestAccessRights(List<Instance> instanceList) {
        if (instanceList != null) {
            Optional<AccessRight> min = instanceList.stream().map(Instance::getAccessright).min((Comparator<AccessRight>)new AccessRightComparator());
            Qualifier rights = min.map(OafMapperUtils::qualifier).orElseGet(Qualifier::new);
            if (StringUtils.isBlank((CharSequence)rights.getClassid())) {
                rights.setClassid("UNKNOWN");
            }
            if (StringUtils.isBlank((CharSequence)rights.getClassname()) || "UNKNOWN".equalsIgnoreCase(rights.getClassname())) {
                rights.setClassname("not available");
            }
            if (StringUtils.isBlank((CharSequence)rights.getSchemeid())) {
                rights.setSchemeid("dnet:access_modes");
            }
            if (StringUtils.isBlank((CharSequence)rights.getSchemename())) {
                rights.setSchemename("dnet:access_modes");
            }
            return rights;
        }
        return null;
    }

    public static KeyValue newKeyValueInstance(String key, String value, DataInfo dataInfo) {
        KeyValue kv = new KeyValue();
        kv.setDataInfo(dataInfo);
        kv.setKey(key);
        kv.setValue(value);
        return kv;
    }

    public static Measure newMeasureInstance(String id, String value, String key, DataInfo dataInfo) {
        Measure m = new Measure();
        m.setId(id);
        m.setUnit(Arrays.asList(OafMapperUtils.newKeyValueInstance(key, value, dataInfo)));
        return m;
    }

    public static Relation getRelation(String source, String target, String relType, String subRelType, String relClass, OafEntity entity) {
        return OafMapperUtils.getRelation(source, target, relType, subRelType, relClass, entity, null);
    }

    public static Relation getRelation(String source, String target, String relType, String subRelType, String relClass, OafEntity entity, String validationDate) {
        return OafMapperUtils.getRelation(source, target, relType, subRelType, relClass, entity.getCollectedfrom(), entity.getDataInfo(), entity.getLastupdatetimestamp(), validationDate, null);
    }

    public static Relation getRelation(String source, String target, String relType, String subRelType, String relClass, List<KeyValue> collectedfrom, DataInfo dataInfo, Long lastupdatetimestamp) {
        return OafMapperUtils.getRelation(source, target, relType, subRelType, relClass, collectedfrom, dataInfo, lastupdatetimestamp, null, null);
    }

    public static Relation getRelation(String source, String target, String relType, String subRelType, String relClass, List<KeyValue> collectedfrom, DataInfo dataInfo, Long lastupdatetimestamp, String validationDate, List<KeyValue> properties) {
        Relation rel = new Relation();
        rel.setRelType(relType);
        rel.setSubRelType(subRelType);
        rel.setRelClass(relClass);
        rel.setSource(source);
        rel.setTarget(target);
        rel.setCollectedfrom(collectedfrom);
        rel.setDataInfo(dataInfo);
        rel.setLastupdatetimestamp(lastupdatetimestamp);
        rel.setValidated(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)validationDate)));
        rel.setValidationDate(StringUtils.isNotBlank((CharSequence)validationDate) ? validationDate : null);
        rel.setProperties(properties);
        return rel;
    }

    public static String getProvenance(DataInfo dataInfo) {
        return Optional.ofNullable(dataInfo).map(d -> Optional.ofNullable(d.getProvenanceaction()).map(Qualifier::getClassid).orElse("")).orElse("");
    }
}

