/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf.utils;

import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.DoiCleaningRule;
import eu.dnetlib.dhp.schema.oaf.utils.FundRefCleaningRule;
import eu.dnetlib.dhp.schema.oaf.utils.GridCleaningRule;
import eu.dnetlib.dhp.schema.oaf.utils.ISNICleaningRule;
import eu.dnetlib.dhp.schema.oaf.utils.PICCleaningRule;
import eu.dnetlib.dhp.schema.oaf.utils.PmcCleaningRule;
import eu.dnetlib.dhp.schema.oaf.utils.PmidCleaningRule;
import eu.dnetlib.dhp.schema.oaf.utils.RorCleaningRule;
import java.util.Optional;

public class PidCleaner {
    public static StructuredProperty normalizePidValue(StructuredProperty pid) {
        pid.setValue(PidCleaner.normalizePidValue(pid.getQualifier().getClassid(), pid.getValue()));
        return pid;
    }

    public static String normalizePidValue(String pidType, String pidValue) {
        String value = Optional.ofNullable(pidValue).map(String::trim).orElseThrow(() -> new IllegalArgumentException("PID (" + pidType + ") value cannot be empty"));
        switch (pidType) {
            case "doi": {
                return DoiCleaningRule.clean(value);
            }
            case "pmid": {
                return PmidCleaningRule.clean(value);
            }
            case "pmc": {
                return PmcCleaningRule.clean(value);
            }
            case "handle": 
            case "arXiv": {
                return value;
            }
            case "GRID": {
                return GridCleaningRule.clean(value);
            }
            case "ISNI": {
                return ISNICleaningRule.clean(value);
            }
            case "ROR": {
                return RorCleaningRule.clean(value);
            }
            case "PIC": {
                return PICCleaningRule.clean(value);
            }
            case "FundRef": {
                return FundRefCleaningRule.clean(value);
            }
        }
        return value;
    }
}

