/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.utils.saxon;

import eu.dnetlib.dhp.utils.saxon.AbstractExtensionFunction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class ExtractYear
extends AbstractExtensionFunction {
    private static final String[] dateFormats = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"};

    @Override
    public String getName() {
        return "extractYear";
    }

    @Override
    public Sequence doCall(XPathContext context, Sequence[] arguments) throws XPathException {
        if (arguments == null || arguments.length == 0) {
            return new StringValue((CharSequence)"");
        }
        Item item = arguments[0].head();
        if (item == null) {
            return new StringValue((CharSequence)"");
        }
        return new StringValue((CharSequence)this._year(item.getStringValue()));
    }

    public int getMinimumNumberOfArguments() {
        return 0;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_ITEM};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    private String _year(String s) {
        GregorianCalendar c = new GregorianCalendar();
        for (String format : dateFormats) {
            try {
                c.setTime(new SimpleDateFormat(format).parse(s));
                return String.valueOf(c.get(1));
            }
            catch (ParseException parseException) {
            }
        }
        return "";
    }
}

