/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.commit.AbstractS3ACommitterFactory;
import org.apache.hadoop.fs.s3a.commit.AbstractS3AOpenAIRECommitter;
import org.apache.hadoop.fs.s3a.commit.PathCommitException;
import org.apache.hadoop.fs.s3a.commit.magic.MagicS3OpenAIRECommitterFactory;
import org.apache.hadoop.fs.s3a.commit.staging.DirectoryStagingCommitterFactory;
import org.apache.hadoop.fs.s3a.commit.staging.PartitionedStagingCommitterFactory;
import org.apache.hadoop.fs.s3a.commit.staging.StagingCommitterFactory;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;

public class S3AOpenAIRECommitterFactory
extends AbstractS3ACommitterFactory {
    public static final String CLASSNAME = "org.apache.hadoop.fs.s3a.commit.S3AOpenAIRECommitterFactory";

    public PathOutputCommitter createTaskCommitter(S3AFileSystem fileSystem, Path outputPath, TaskAttemptContext context) throws IOException {
        AbstractS3ACommitterFactory factory = this.chooseCommitterFactory(fileSystem, outputPath, context.getConfiguration());
        if (factory != null) {
            PathOutputCommitter committer = factory.createTaskCommitter(fileSystem, outputPath, context);
            LOG.info("Using committer {} to output data to {}", (Object)(committer instanceof AbstractS3AOpenAIRECommitter ? ((AbstractS3AOpenAIRECommitter)committer).getName() : committer.toString()), (Object)outputPath);
            return committer;
        }
        LOG.warn("Using standard FileOutputCommitter to commit work. This is slow and potentially unsafe.");
        return this.createFileOutputCommitter(outputPath, context);
    }

    private AbstractS3ACommitterFactory chooseCommitterFactory(S3AFileSystem fileSystem, Path outputPath, Configuration taskConf) throws PathCommitException {
        Configuration fsConf = fileSystem.getConf();
        String name = fsConf.getTrimmed("fs.s3a.committer.name", "");
        LOG.debug("Committer from filesystems \"{}\"", (Object)name);
        name = taskConf.getTrimmed("fs.s3a.committer.name", name);
        LOG.debug("Committer option is \"{}\"", (Object)name);
        return switch (name) {
            case "file", "" -> null;
            case "directory" -> new DirectoryStagingCommitterFactory();
            case "partitioned" -> new PartitionedStagingCommitterFactory();
            case "magic" -> new MagicS3OpenAIRECommitterFactory();
            case "staging" -> new StagingCommitterFactory();
            default -> throw new PathCommitException(outputPath, "Unknown committer: \"" + name + "\"");
        };
    }
}

