/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.vocabulary;

import com.google.common.collect.Maps;
import eu.dnetlib.dhp.common.vocabulary.VocabularyTerm;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Vocabulary
implements Serializable {
    private final String id;
    private final String name;
    private final Map<String, VocabularyTerm> terms = new HashMap<String, VocabularyTerm>();
    private final Map<String, String> synonyms = Maps.newHashMap();

    public Vocabulary(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    protected Map<String, VocabularyTerm> getTerms() {
        return this.terms;
    }

    public VocabularyTerm getTerm(String id) {
        return Optional.ofNullable(id).map(String::toLowerCase).map(this.terms::get).orElse(null);
    }

    protected void addTerm(String id, String name) {
        this.terms.put(id.toLowerCase(), new VocabularyTerm(id, name));
    }

    protected boolean termExists(String id) {
        return this.terms.containsKey(id.toLowerCase());
    }

    protected void addSynonym(String syn, String termCode) {
        this.synonyms.put(syn, termCode.toLowerCase());
    }

    public VocabularyTerm getTermBySynonym(String syn) {
        return Optional.ofNullable(syn).map(s -> this.getTerm(this.synonyms.get(s.toLowerCase()))).orElse(null);
    }

    public Qualifier getTermAsQualifier(String termId) {
        return this.getTermAsQualifier(termId, false);
    }

    public Qualifier getTermAsQualifier(String termId, boolean strict) {
        VocabularyTerm term = this.getTerm(termId);
        if (Objects.nonNull(term)) {
            return OafMapperUtils.qualifier(term.getId(), term.getName(), this.getId(), this.getName());
        }
        if (Objects.isNull(term) && strict) {
            return OafMapperUtils.unknown(this.getId(), this.getName());
        }
        return OafMapperUtils.qualifier(termId, termId, this.getId(), this.getName());
    }

    public Qualifier getSynonymAsQualifier(String syn) {
        return this.getSynonymAsQualifier(syn, false);
    }

    public Qualifier getSynonymAsQualifier(String syn, boolean strict) {
        return Optional.ofNullable(this.getTermBySynonym(syn)).map(term -> this.getTermAsQualifier(term.getId(), strict)).orElse(null);
    }

    public Qualifier lookup(String id) {
        return this.lookup(id, false);
    }

    public Qualifier lookup(String id, boolean strict) {
        return Optional.ofNullable(this.getSynonymAsQualifier(id, strict)).orElse(this.getTermAsQualifier(id, strict));
    }
}

