/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.person;

import eu.dnetlib.dhp.common.person.Constants;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CoAuthorshipIterator
implements Iterator<Relation> {
    private int firstIndex;
    private int secondIndex;
    private boolean firstRelation;
    private List<String> authors;

    @Override
    public boolean hasNext() {
        return this.firstIndex < this.authors.size() - 1;
    }

    @Override
    public Relation next() {
        Relation rel = null;
        if (this.firstRelation) {
            rel = this.getRelation(this.authors.get(this.firstIndex), this.authors.get(this.secondIndex));
            this.firstRelation = Boolean.FALSE;
        } else {
            rel = this.getRelation(this.authors.get(this.secondIndex), this.authors.get(this.firstIndex));
            this.firstRelation = Boolean.TRUE;
            ++this.secondIndex;
            if (this.secondIndex >= this.authors.size()) {
                ++this.firstIndex;
                this.secondIndex = this.firstIndex + 1;
            }
        }
        return rel;
    }

    public CoAuthorshipIterator(List<String> authors) {
        this.authors = new ArrayList<String>(new HashSet<String>(authors));
        this.firstIndex = 0;
        this.secondIndex = 1;
        this.firstRelation = Boolean.TRUE;
    }

    private Relation getRelation(String orcid1, String orcid2) {
        String source = Constants.PERSON_PREFIX + "::" + IdentifierFactory.md5(orcid1);
        String target = Constants.PERSON_PREFIX + "::" + IdentifierFactory.md5(orcid2);
        Relation relation = OafMapperUtils.getRelation(source, target, "personPerson", "coAuthorship", "hasCoAuthor", Collections.singletonList(OafMapperUtils.keyValue(Constants.ORCID_KEY, ModelConstants.ORCID_DS)), Constants.ORCIDDATAINFO, null);
        relation.setValidated(Boolean.valueOf(true));
        return relation;
    }
}

