/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbClient
implements Closeable {
    private static final Log log = LogFactory.getLog(DbClient.class);
    private final Connection connection;

    public DbClient(String address, String login, String password) {
        try {
            Class.forName("org.postgresql.Driver");
            this.connection = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{login, password}) ? DriverManager.getConnection(address, login, password) : DriverManager.getConnection(address);
            this.connection.setAutoCommit(false);
        }
        catch (Exception e) {
            log.error((Object)"Connection to postgresDB failed");
            throw new RuntimeException("Connection to postgresDB failed", e);
        }
        log.info((Object)"Opened database successfully");
    }

    public void processResults(String sql, Consumer<ResultSet> consumer) {
        try (Statement stmt = this.connection.createStatement();){
            stmt.setFetchSize(100);
            try (ResultSet rs = stmt.executeQuery(sql);){
                while (rs.next()) {
                    consumer.accept(rs);
                }
            }
            catch (SQLException e) {
                log.error((Object)("Error executing sql query: " + sql), (Throwable)e);
                throw new RuntimeException("Error executing sql query", e);
            }
        }
        catch (SQLException e1) {
            log.error((Object)"Error preparing sql statement", (Throwable)e1);
            throw new RuntimeException("Error preparing sql statement", e1);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

